/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatUtils {
    public static final Class<?> byteArray = byte[].class;
    public static final Class<?> shortArray = short[].class;
    public static final Class<?> intArray = int[].class;
    public static final Class<?> formatArray = Format[].class;
    public static final Class<?> videoFormatClass = VideoFormat.class;
    public static final Class<?> audioFormatClass = AudioFormat.class;

    public static boolean byteArraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int charEncodingCodeVal(char c) {
        if (c <= '_') {
            return c - 32;
        }
        if (c == '`') {
            return -1;
        }
        if (c <= 'z') {
            return c - 64;
        }
        if (c <= '\u007f') {
            return -1;
        }
        if (c <= '\u00bf') {
            return -94;
        }
        if (c <= '\u00ff') {
            return -93;
        }
        return -1;
    }

    public static Dimension clone(Dimension dimension) {
        if (dimension == null) {
            return null;
        }
        return new Dimension(dimension);
    }

    public static String frameRateToString(float f) {
        f = (float)((long)(f * 10.0f)) / 10.0f;
        String string = "" + f;
        return string;
    }

    public static boolean isOneAssignableFromTheOther(Class<?> clazz, Class<?> clazz2) {
        return clazz == clazz2 || clazz2.isAssignableFrom(clazz) || clazz.isAssignableFrom(clazz2);
    }

    public static boolean isSubclass(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean matches(double d, double d2) {
        if (d == -1.0 || d2 == -1.0) {
            return true;
        }
        return d == d2;
    }

    public static boolean matches(float f, float f2) {
        if (f == -1.0f || f2 == -1.0f) {
            return true;
        }
        return f == f2;
    }

    public static boolean matches(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return true;
        }
        return n == n2;
    }

    public static boolean matches(Object object, Object object2) {
        if (object == null || object2 == null) {
            return true;
        }
        return object.equals(object2);
    }

    public static boolean nullSafeEquals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean nullSafeEqualsIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean specified(double d) {
        return d != -1.0;
    }

    public static boolean specified(float f) {
        return f != -1.0f;
    }

    public static boolean specified(int n) {
        return n != -1;
    }

    public static boolean specified(Object object) {
        return object != null;
    }

    public static long stringEncodingCodeVal(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            l *= 64L;
            l += (long)FormatUtils.charEncodingCodeVal(c);
        }
        return l;
    }
}

