/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.registry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.PackageManager;
import javax.media.PlugInManager;
import javax.media.protocol.DataSource;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.ui.registry.DetailsListener;
import net.sf.fmj.utility.LoggerSingleton;

public class EntryPanel
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    public static final int TYPE_DEMUX = 1;
    public static final int TYPE_CODEC = 2;
    public static final int TYPE_EFFECT = 3;
    public static final int TYPE_RENDERER = 4;
    public static final int TYPE_MUX = 5;
    public static final int TYPE_CONTENT = 10001;
    public static final int TYPE_PROTOCOL = 10002;
    public static final int TYPE_CAPTURE_DEVICE = 10003;
    public static final int TYPE_MIME_TYPES = 10004;
    private final int type;
    private JPanel actionPanel = null;
    private JButton addButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton removeButton = null;
    private JButton commitButton = null;
    private JPanel entryPanel = null;
    private JPanel entryTopPanel = null;
    private JLabel entryLabel = null;
    private JTextField entryTextField = null;
    private JTextField entryTextField2 = null;
    private JList entryList = null;
    private DefaultComboBoxModel entryListModel = null;
    private JScrollPane listScrollPane = null;
    private DetailsListener detailsListener;

    public EntryPanel(int n) {
        this.type = n;
        this.initialize();
    }

    private void addEntry(String string, String string2) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Format[] formatArray = null;
                Format[] formatArray2 = null;
                boolean bl = PlugInManager.addPlugIn(string, formatArray, formatArray2, this.type);
                if (!bl) break;
                this.getEntryListModel().addElement(string);
                break;
            }
            case 10001: {
                Vector vector = PackageManager.getContentPrefixList();
                if (vector.contains(string)) break;
                vector.add(string);
                PackageManager.setContentPrefixList(vector);
                this.getEntryListModel().addElement(string);
                break;
            }
            case 10002: {
                Vector vector = PackageManager.getProtocolPrefixList();
                if (vector.contains(string)) break;
                vector.add(string);
                PackageManager.setContentPrefixList(vector);
                this.getEntryListModel().addElement(string);
                break;
            }
            case 10003: {
                break;
            }
            case 10004: {
                List<String> list = MimeManager.getExtensions(string);
                if (list.contains(string2)) break;
                MimeManager.addMimeType(string2, string);
                this.getEntryListModel().addElement(string);
            }
        }
    }

    private boolean canMoveItems() {
        return this.type != 10004;
    }

    private void commit() {
        try {
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Vector vector = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object e = this.getEntryListModel().getElementAt(i);
                        vector.add(e);
                    }
                    PlugInManager.setPlugInList(vector, this.type);
                    PlugInManager.commit();
                    break;
                }
                case 10001: {
                    Vector vector = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object e = this.getEntryListModel().getElementAt(i);
                        vector.add(e);
                    }
                    PackageManager.setContentPrefixList(vector);
                    PackageManager.commitContentPrefixList();
                    break;
                }
                case 10002: {
                    Vector vector = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object e = this.getEntryListModel().getElementAt(i);
                        vector.add(e);
                    }
                    PackageManager.setProtocolPrefixList(vector);
                    PackageManager.commitProtocolPrefixList();
                    break;
                }
                case 10003: {
                    int n;
                    CaptureDeviceInfo[] captureDeviceInfoArray = new CaptureDeviceInfo[this.getEntryListModel().getSize()];
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object e = this.getEntryListModel().getElementAt(i);
                        captureDeviceInfoArray[i] = CaptureDeviceManager.getDevice((String)e);
                    }
                    Vector vector = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
                    for (n = 0; n < vector.size(); ++n) {
                        CaptureDeviceManager.removeDevice((CaptureDeviceInfo)vector.elementAt(n));
                    }
                    for (n = 0; n < captureDeviceInfoArray.length; ++n) {
                        CaptureDeviceManager.addDevice(captureDeviceInfoArray[n]);
                    }
                    CaptureDeviceManager.commit();
                    break;
                }
                case 10004: {
                    MimeManager.commit();
                }
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = insets;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = insets;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.fill = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = insets;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = insets;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.fill = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = insets;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.fill = 2;
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new GridBagLayout());
            this.actionPanel.add((Component)this.getAddButton(), gridBagConstraints5);
            if (this.canMoveItems()) {
                this.actionPanel.add((Component)this.getMoveUpButton(), gridBagConstraints4);
                this.actionPanel.add((Component)this.getMoveDownButton(), gridBagConstraints3);
            }
            this.actionPanel.add((Component)this.getRemoveButton(), gridBagConstraints2);
            this.actionPanel.add((Component)this.getCommitButton(), gridBagConstraints);
        }
        return this.actionPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = EntryPanel.this.getEntryTextField().getText();
                    String string2 = EntryPanel.this.getEntryTextField2() != null ? EntryPanel.this.getEntryTextField2().getText() : null;
                    EntryPanel.this.addEntry(string, string2);
                }
            });
        }
        return this.addButton;
    }

    private JButton getCommitButton() {
        if (this.commitButton == null) {
            this.commitButton = new JButton();
            this.commitButton.setText("Commit");
            this.commitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EntryPanel.this.commit();
                }
            });
        }
        return this.commitButton;
    }

    public DetailsListener getDetailsListener() {
        return this.detailsListener;
    }

    private JLabel getEntryLabel() {
        if (this.entryLabel == null) {
            this.entryLabel = new JLabel();
            this.entryLabel.setText("Title");
        }
        return this.entryLabel;
    }

    private JList getEntryList() {
        if (this.entryList == null) {
            this.entryList = new JList(this.getEntryListModel());
            this.entryList.setDragEnabled(true);
            this.entryList.setSelectionMode(0);
            this.entryList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        EntryPanel.this.updateDetailsPane(EntryPanel.this.entryList.getSelectedIndex(), EntryPanel.this.entryList.getSelectedValue());
                    }
                }
            });
        }
        return this.entryList;
    }

    private DefaultComboBoxModel getEntryListModel() {
        if (this.entryListModel == null) {
            this.entryListModel = new DefaultComboBoxModel();
        }
        return this.entryListModel;
    }

    private JPanel getEntryPanel() {
        if (this.entryPanel == null) {
            this.entryPanel = new JPanel();
            this.entryPanel.setLayout(new BorderLayout());
            this.entryPanel.add((Component)this.getEntryTopPanel(), "North");
            this.entryPanel.add((Component)this.getListScrollPane(), "Center");
        }
        return this.entryPanel;
    }

    private JTextField getEntryTextField() {
        if (this.entryTextField == null) {
            this.entryTextField = new JTextField();
            this.entryTextField.setEditable(true);
        }
        return this.entryTextField;
    }

    private JTextField getEntryTextField2() {
        if (this.type != 10004) {
            return null;
        }
        if (this.entryTextField2 == null) {
            this.entryTextField2 = new JTextField();
            this.entryTextField2.setEditable(true);
        }
        return this.entryTextField2;
    }

    private JPanel getEntryTopPanel() {
        if (this.entryTopPanel == null) {
            this.entryTopPanel = new JPanel();
            int n = this.usesSecondEntryTextField() ? 3 : 2;
            this.entryTopPanel.setLayout(new GridLayout(n, 1));
            this.entryTopPanel.add(this.getEntryLabel());
            this.entryTopPanel.add(this.getEntryTextField());
            if (this.usesSecondEntryTextField()) {
                this.entryTopPanel.add(this.getEntryTextField2());
            }
        }
        return this.entryTopPanel;
    }

    private JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane(this.getEntryList());
        }
        return this.listScrollPane;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = EntryPanel.this.getEntryList().getSelectedIndices();
                    int n = nArray.length - 1;
                    while (n >= 0) {
                        int n2 = nArray[n];
                        if (n2 == EntryPanel.this.getEntryListModel().getSize() - 1) {
                            return;
                        }
                        Object e = EntryPanel.this.getEntryListModel().getElementAt(n2);
                        EntryPanel.this.getEntryListModel().removeElementAt(n2);
                        EntryPanel.this.getEntryListModel().insertElementAt(e, n2 + 1);
                        int n3 = n--;
                        nArray[n3] = nArray[n3] + 1;
                    }
                    EntryPanel.this.getEntryList().setSelectedIndices(nArray);
                }
            });
        }
        return this.moveDownButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int[] nArray = EntryPanel.this.getEntryList().getSelectedIndices();
                    int n2 = 0;
                    while (n2 < nArray.length && (n = nArray[n2]) != 0) {
                        Object e = EntryPanel.this.getEntryListModel().getElementAt(n);
                        EntryPanel.this.getEntryListModel().removeElementAt(n);
                        EntryPanel.this.getEntryListModel().insertElementAt(e, n - 1);
                        int n3 = n2++;
                        nArray[n3] = nArray[n3] - 1;
                    }
                    EntryPanel.this.getEntryList().setSelectedIndices(nArray);
                }
            });
        }
        return this.moveUpButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = EntryPanel.this.getEntryList().getSelectedIndices();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n = nArray[i];
                        Object e = EntryPanel.this.getEntryListModel().getElementAt(n);
                        String string = (String)EntryPanel.this.getEntryListModel().getElementAt(n);
                        EntryPanel.this.removeEntry(string);
                    }
                }
            });
        }
        return this.removeButton;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(313, 280));
        this.add((Component)this.getActionPanel(), "East");
        this.add((Component)this.getEntryPanel(), "Center");
        this.load();
    }

    void load() {
        Vector vector = null;
        this.getEntryListModel().removeAllElements();
        switch (this.type) {
            case 1: {
                vector = PlugInManager.getPlugInList(null, null, 1);
                this.setTitle("Demultiplexer");
                break;
            }
            case 2: {
                vector = PlugInManager.getPlugInList(null, null, 2);
                this.setTitle("Codec");
                break;
            }
            case 3: {
                vector = PlugInManager.getPlugInList(null, null, 3);
                this.setTitle("Effect");
                break;
            }
            case 4: {
                vector = PlugInManager.getPlugInList(null, null, 4);
                this.setTitle("Renderer");
                break;
            }
            case 5: {
                vector = PlugInManager.getPlugInList(null, null, 5);
                this.setTitle("Multiplexer");
                break;
            }
            case 10001: {
                vector = PackageManager.getContentPrefixList();
                this.setTitle("Content Prefix List");
                break;
            }
            case 10002: {
                vector = PackageManager.getProtocolPrefixList();
                this.setTitle("Protocol Prefix List");
                break;
            }
            case 10003: {
                vector = new Vector();
                Vector vector2 = CaptureDeviceManager.getDeviceList(null);
                for (int i = 0; i < vector2.size(); ++i) {
                    CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector2.get(i);
                    vector.add(captureDeviceInfo.getName());
                }
                this.setTitle("Capture Devices");
                break;
            }
            case 10004: {
                vector = new Vector();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.addAll(MimeManager.getMimeTable().values());
                vector.addAll(hashSet);
                Collections.sort(vector);
                this.setTitle("MIME Types");
                break;
            }
            default: {
                vector = new Vector();
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.getEntryListModel().addElement(vector.get(i));
        }
    }

    private void removeEntry(String string) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Object var2_2 = null;
                Object var3_3 = null;
                boolean bl = PlugInManager.removePlugIn(string, this.type);
                if (!bl) break;
                this.getEntryListModel().removeElement(string);
                break;
            }
            case 10001: {
                Vector vector = PackageManager.getContentPrefixList();
                if (!vector.remove(string)) break;
                PackageManager.setContentPrefixList(vector);
                this.getEntryListModel().removeElement(string);
                break;
            }
            case 10002: {
                Vector vector = PackageManager.getProtocolPrefixList();
                if (!vector.remove(string)) break;
                PackageManager.setProtocolPrefixList(vector);
                this.getEntryListModel().removeElement(string);
                break;
            }
            case 10003: {
                CaptureDeviceInfo captureDeviceInfo = CaptureDeviceManager.getDevice(string);
                this.getEntryListModel().removeElement(string);
                CaptureDeviceManager.removeDevice(captureDeviceInfo);
                break;
            }
            case 10004: {
                List<String> list = MimeManager.getExtensions(string);
                int n = 0;
                if (list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (!MimeManager.removeMimeType(list.get(i))) continue;
                        ++n;
                    }
                }
                if (n <= 0) break;
                this.getEntryListModel().removeElement(string);
            }
        }
    }

    public void setDetailsListener(DetailsListener detailsListener) {
        this.detailsListener = detailsListener;
    }

    public void setTitle(String string) {
        this.getEntryLabel().setText(string);
    }

    private void updateDetailsPane(int n, Object object) {
        if (this.detailsListener == null) {
            return;
        }
        if (object == null) {
            this.detailsListener.onDetails("");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int n2;
                String string = (String)object;
                Format[] formatArray = PlugInManager.getSupportedInputFormats(string, this.type);
                Format[] formatArray2 = PlugInManager.getSupportedOutputFormats(string, this.type);
                stringBuffer.append("Input Formats ---->\n\n");
                if (formatArray != null) {
                    for (n2 = 0; n2 < formatArray.length; ++n2) {
                        stringBuffer.append(n2 + ". " + formatArray[n2].getClass().getName() + "\n " + formatArray[n2] + "\n");
                    }
                }
                stringBuffer.append("\n\n");
                stringBuffer.append("Output Formats ---->\n\n");
                if (formatArray2 != null) {
                    for (n2 = 0; n2 < formatArray2.length; ++n2) {
                        stringBuffer.append(n2 + ". " + formatArray2[n2].getClass().getName() + "\n " + formatArray2[n2] + "\n");
                    }
                }
            }
            case 10004: {
                String string = (String)object;
                Format[] formatArray = MimeManager.getExtensions(string);
                for (int i = 0; i < formatArray.size(); ++i) {
                    stringBuffer.append((String)formatArray.get(i) + "\n");
                }
                break;
            }
            case 10003: {
                try {
                    CaptureDeviceInfo captureDeviceInfo = CaptureDeviceManager.getDevice((String)object);
                    DataSource dataSource = Manager.createDataSource(captureDeviceInfo.getLocator());
                    dataSource.connect();
                    stringBuffer.append("Name = " + captureDeviceInfo.getName());
                    stringBuffer.append("\n\n");
                    stringBuffer.append("Locator = " + captureDeviceInfo.getLocator());
                    stringBuffer.append("\n\n");
                    stringBuffer.append("Output Formats ---->\n\n");
                    Format[] formatArray = captureDeviceInfo.getFormats();
                    if (null != formatArray) {
                        for (int i = 0; i < formatArray.length; ++i) {
                            stringBuffer.append(i + ". " + formatArray[i].getClass().getName() + "\n " + formatArray[i] + "\n");
                        }
                    }
                    dataSource.disconnect();
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.detailsListener.onDetails(stringBuffer.toString());
    }

    private boolean usesSecondEntryTextField() {
        return this.type == 10004;
    }
}

