/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.cdp.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.VideoFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import net.sf.fmj.media.protocol.civil.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDevicePlugger {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean QUERY_EXACT_FORMATS = true;

    private static Format[] getFormats(CaptureSystem captureSystem, String string) throws CaptureException {
        CaptureStream captureStream = captureSystem.openCaptureDeviceStream(string);
        List list = captureStream.enumVideoFormats();
        Format[] formatArray = new Format[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            formatArray[i] = DataSource.convertCivilFormat((VideoFormat)list.get(i));
        }
        captureStream.dispose();
        return formatArray;
    }

    public void addCaptureDevices() {
        try {
            CaptureSystemFactory captureSystemFactory = DefaultCaptureSystemFactorySingleton.instance();
            CaptureSystem captureSystem = captureSystemFactory.createCaptureSystem();
            captureSystem.init();
            List list = captureSystem.getCaptureDeviceInfoList();
            for (int i = 0; i < list.size(); ++i) {
                com.lti.civil.CaptureDeviceInfo captureDeviceInfo = (com.lti.civil.CaptureDeviceInfo)list.get(i);
                Format[] formatArray = CaptureDevicePlugger.getFormats(captureSystem, captureDeviceInfo.getDeviceID());
                CaptureDeviceInfo captureDeviceInfo2 = new CaptureDeviceInfo("civil:" + captureDeviceInfo.getDescription() + ":" + i, new MediaLocator("civil:" + captureDeviceInfo.getDeviceID()), formatArray);
                if (CaptureDeviceManager.getDevice(captureDeviceInfo2.getName()) == null) {
                    CaptureDeviceManager.addDevice(captureDeviceInfo2);
                    logger.fine("CaptureDevicePlugger: Added " + captureDeviceInfo2.getLocator());
                    continue;
                }
                logger.fine("CaptureDevicePlugger: Already present, skipping " + captureDeviceInfo2.getLocator());
            }
        }
        catch (CaptureException captureException) {
            logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
        }
    }
}

