/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.RateChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RateControlComponent
extends JPanel
implements ActionListener,
ControllerListener {
    private JTextField rateField = new JTextField(6);
    private Controller controller;

    public RateControlComponent(Controller controller) {
        this.controller = controller;
        this.setUpControlComponent();
        SwingUtilities.invokeLater(new LoadRateThread());
        this.rateField.addActionListener(this);
        controller.addControllerListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.rateField) {
            return;
        }
        try {
            String string = this.rateField.getText();
            float f = Float.valueOf(string).floatValue();
            this.controller.setRate(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.loadRate();
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent.getSourceController() == this.controller && controllerEvent instanceof RateChangeEvent) {
            SwingUtilities.invokeLater(new LoadRateThread());
        }
    }

    private void loadRate() {
        this.rateField.setText(Float.toString(this.controller.getRate()));
    }

    private void setUpControlComponent() {
        JLabel jLabel = new JLabel("Rate:", 4);
        JPanel jPanel = new JPanel();
        int n = 10;
        EmptyBorder emptyBorder = new EmptyBorder(n, n, n, n);
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), emptyBorder);
        TitledBorder titledBorder = new TitledBorder(compoundBorder, "Rate Control");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout(n, n));
        jPanel.add((Component)jLabel, "Center");
        jPanel.add((Component)this.rateField, "East");
        this.add(jPanel);
    }

    class LoadRateThread
    implements Runnable {
        LoadRateThread() {
        }

        public void run() {
            RateControlComponent.this.loadRate();
        }
    }
}

