/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.sip;

import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;

public class SipAccountID
extends AccountID {
    public static final String XCAP_ENABLE = "XCAP_ENABLE";
    public static final String XIVO_ENABLE = "XIVO_ENABLE";
    public static final String OPT_CLIST_USE_SIP_CREDETIALS = "OPT_CLIST_USE_SIP_CREDETIALS";
    public static final String OPT_CLIST_SERVER_URI = "OPT_CLIST_SERVER_URI";
    public static final String OPT_CLIST_USER = "OPT_CLIST_USER";
    public static final String OPT_CLIST_PASSWORD = "OPT_CLIST_PASSWORD";
    private static final String SIP_DEFAULTS_PREFIX = "net.java.sip.communicator.service.protocol.sip.";

    protected SipAccountID(String userID, Map<String, String> accountProperties, String serverName) {
        super(userID, accountProperties, "SIP", serverName);
    }

    public SipAccountID() {
        super(null, new HashMap<String, String>(), "SIP", null);
    }

    public String getProxy() {
        return this.getAccountPropertyString("PROXY_ADDRESS");
    }

    public void setProxy(String proxy) {
        this.setOrRemoveIfEmpty("PROXY_ADDRESS", proxy);
    }

    public String getId() {
        return this.getAccountPropertyString("USER_ID");
    }

    public String getPreferredTransport() {
        return this.getAccountPropertyString("PREFERRED_TRANSPORT");
    }

    public void setPreferredTransport(String preferredTransport) {
        this.putAccountProperty("PREFERRED_TRANSPORT", preferredTransport);
    }

    public String getProxyPort() {
        return this.getAccountPropertyString("PROXY_PORT");
    }

    public void setUserID(String id) {
        this.putAccountProperty("USER_ID", id);
    }

    public boolean isProxyAutoConfigure() {
        return this.getAccountPropertyBoolean("PROXY_AUTO_CONFIG", true);
    }

    public void setProxyAutoConfigure(boolean proxyAutoConfigure) {
        this.putAccountProperty("PROXY_AUTO_CONFIG", proxyAutoConfigure);
    }

    public void setProxyPort(String port) {
        this.setOrRemoveIfEmpty("PROXY_PORT", port);
    }

    public boolean isEnablePresence() {
        return this.getAccountPropertyBoolean("IS_PRESENCE_ENABLED", true);
    }

    public boolean isForceP2PMode() {
        return this.getAccountPropertyBoolean("FORCE_P2P_MODE", false);
    }

    public String getPollingPeriod() {
        return this.getAccountPropertyString("POLLING_PERIOD");
    }

    public String getSubscriptionExpiration() {
        return this.getAccountPropertyString("SUBSCRIPTION_EXPIRATION");
    }

    public void setEnablePresence(boolean enablePresence) {
        this.putAccountProperty("IS_PRESENCE_ENABLED", enablePresence);
    }

    public void setForceP2PMode(boolean forceP2PMode) {
        this.putAccountProperty("FORCE_P2P_MODE", forceP2PMode);
    }

    public void setPollingPeriod(String pollingPeriod) {
        this.putAccountProperty("POLLING_PERIOD", pollingPeriod);
    }

    public void setSubscriptionExpiration(String subscriptionExpiration) {
        this.putAccountProperty("SUBSCRIPTION_EXPIRATION", subscriptionExpiration);
    }

    public String getKeepAliveMethod() {
        return this.getAccountPropertyString("KEEP_ALIVE_METHOD");
    }

    public void setKeepAliveMethod(String keepAliveMethod) {
        this.putAccountProperty("KEEP_ALIVE_METHOD", keepAliveMethod);
    }

    public String getKeepAliveInterval() {
        return this.getAccountPropertyString("KEEP_ALIVE_INTERVAL");
    }

    public void setKeepAliveInterval(String keepAliveInterval) {
        this.putAccountProperty("KEEP_ALIVE_INTERVAL", keepAliveInterval);
    }

    public boolean isXCapEnable() {
        return this.getAccountPropertyBoolean(XCAP_ENABLE, false);
    }

    public void setXCapEnable(boolean xCapEnable) {
        this.putAccountProperty(XCAP_ENABLE, xCapEnable);
    }

    public boolean isXiVOEnable() {
        return this.getAccountPropertyBoolean(XIVO_ENABLE, false);
    }

    public void setXiVOEnable(boolean xivoEnable) {
        this.putAccountProperty(XIVO_ENABLE, xivoEnable);
    }

    private String getXcapCompatible(String newKey, String oldKeyXcap, String oldKeyXivo) {
        String oldKey;
        String value = this.getAccountPropertyString(newKey);
        if (value == null && (value = this.getAccountPropertyString(oldKey = this.isXCapEnable() ? oldKeyXcap : oldKeyXivo)) != null) {
            this.accountProperties.remove(oldKey);
            this.accountProperties.put(newKey, value);
        }
        return value;
    }

    public boolean isClistOptionUseSipCredentials() {
        String val = this.getXcapCompatible(OPT_CLIST_USE_SIP_CREDETIALS, "XCAP_USE_SIP_CREDETIALS", "XIVO_USE_SIP_CREDETIALS");
        if (val == null) {
            this.getDefaultString(OPT_CLIST_USE_SIP_CREDETIALS);
        }
        return Boolean.parseBoolean(val);
    }

    public void setClistOptionUseSipCredentials(boolean useSipCredentials) {
        this.putAccountProperty(OPT_CLIST_USE_SIP_CREDETIALS, useSipCredentials);
    }

    public String getClistOptionServerUri() {
        return this.getXcapCompatible(OPT_CLIST_SERVER_URI, "XCAP_SERVER_URI", "XIVO_SERVER_URI");
    }

    public void setClistOptionServerUri(String clistOptionServerUri) {
        this.setOrRemoveIfNull(OPT_CLIST_SERVER_URI, clistOptionServerUri);
    }

    public String getClistOptionUser() {
        return this.getXcapCompatible(OPT_CLIST_USER, "XCAP_USER", "XIVO_USER");
    }

    public void setClistOptionUser(String clistOptionUser) {
        this.setOrRemoveIfNull(OPT_CLIST_USER, clistOptionUser);
    }

    public String getClistOptionPassword() {
        return this.getXcapCompatible(OPT_CLIST_PASSWORD, "XCAP_PASSWORD", "XIVO_PASSWORD");
    }

    public void setClistOptionPassword(String clistOptionPassword) {
        this.setOrRemoveIfEmpty(OPT_CLIST_PASSWORD, clistOptionPassword);
    }

    public String getVoicemailURI() {
        return this.getAccountPropertyString("VOICEMAIL_URI");
    }

    public void setVoicemailURI(String voicemailURI) {
        this.putAccountProperty("VOICEMAIL_URI", voicemailURI);
    }

    public String getVoicemailCheckURI() {
        return this.getAccountPropertyString("VOICEMAIL_CHECK_URI");
    }

    public void setVoicemailCheckURI(String voicemailCheckURI) {
        this.putAccountProperty("VOICEMAIL_CHECK_URI", voicemailCheckURI);
    }

    public boolean isMessageWaitingIndicationsEnabled() {
        return this.getAccountPropertyBoolean("VOICEMAIL_ENABLED", true);
    }

    public void setMessageWaitingIndications(boolean messageWaitingIndications) {
        this.putAccountProperty("VOICEMAIL_ENABLED", messageWaitingIndications);
    }

    @Override
    public String getProtocolName() {
        return "SIP";
    }

    @Override
    public String getAccountAddress() {
        StringBuffer accountAddress = new StringBuffer();
        accountAddress.append("sip:");
        accountAddress.append(this.getUserID());
        String service = this.getService();
        if (service != null) {
            accountAddress.append('@');
            accountAddress.append(service);
        }
        return accountAddress.toString();
    }

    @Override
    protected String getDefaultString(String key) {
        return SipAccountID.getDefaultStr(key);
    }

    public static String getDefaultStr(String key) {
        String value = ProtocolProviderActivator.getConfigurationService().getString(SIP_DEFAULTS_PREFIX + key);
        if (value == null) {
            value = AccountID.getDefaultStr(key);
        }
        return value;
    }

    public static String getServerFromUserName(String userName) {
        int delimIndex = userName.indexOf("@");
        if (delimIndex != -1) {
            return userName.substring(delimIndex + 1);
        }
        return null;
    }
}

