/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.media.Buffer;

public class InputStreamReader
extends InputStream {
    private ReaderThread readerThread;
    private final ProducerConsumerQueue emptyQueue = new ProducerConsumerQueue();
    private final ProducerConsumerQueue fullQueue = new ProducerConsumerQueue();
    private boolean readerThreadStarted;
    private Buffer readBuffer;
    private IOException readException;

    public InputStreamReader(InputStream inputStream, int n) {
        for (int i = 0; i < 2; ++i) {
            Buffer buffer = new Buffer();
            buffer.setData(new byte[n]);
            try {
                this.emptyQueue.put(buffer);
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        this.readerThread = new ReaderThread(this.emptyQueue, this.fullQueue, inputStream, n);
        this.readerThread.setName("ReaderThread for " + inputStream);
        this.readerThread.setDaemon(true);
    }

    public int available() throws IOException {
        if (this.readException != null) {
            throw this.readException;
        }
        if (this.readBuffer != null && this.readBuffer.getLength() > 0) {
            return this.readBuffer.getLength();
        }
        return 0;
    }

    public void close() throws IOException {
        super.close();
        if (this.readerThread != null) {
            this.readerThread.close();
            this.readerThread = null;
        }
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            Object object;
            if (this.readBuffer == null && this.readException == null) {
                object = this.fullQueue.get();
                if (object instanceof IOException) {
                    this.readException = (IOException)object;
                } else {
                    this.readBuffer = (Buffer)object;
                }
            }
            if (this.readException != null) {
                throw this.readException;
            }
            if (this.readBuffer.isEOM()) {
                return -1;
            }
            object = (byte[])this.readBuffer.getData();
            int n3 = this.readBuffer.getLength() < n2 ? this.readBuffer.getLength() : n2;
            System.arraycopy(object, this.readBuffer.getOffset(), byArray, n, n3);
            this.readBuffer.setOffset(this.readBuffer.getOffset() + n3);
            this.readBuffer.setLength(this.readBuffer.getLength() - n3);
            if (this.readBuffer.getLength() == 0) {
                this.emptyQueue.put(this.readBuffer);
                this.readBuffer = null;
            }
            return n3;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    public void startReaderThread() {
        if (!this.readerThreadStarted) {
            this.readerThread.start();
            this.readerThreadStarted = true;
        }
    }

    private static class ReaderThread
    extends CloseableThread {
        private final ProducerConsumerQueue emptyQueue;
        private final ProducerConsumerQueue fullQueue;
        private final InputStream is;
        private final int bufferSize;

        public ReaderThread(ProducerConsumerQueue producerConsumerQueue, ProducerConsumerQueue producerConsumerQueue2, InputStream inputStream, int n) {
            this.emptyQueue = producerConsumerQueue;
            this.fullQueue = producerConsumerQueue2;
            this.is = inputStream;
            this.bufferSize = n;
        }

        public void run() {
            try {
                while (!this.isClosing()) {
                    Buffer buffer = (Buffer)this.emptyQueue.get();
                    buffer.setEOM(false);
                    buffer.setLength(0);
                    buffer.setOffset(0);
                    int n = this.is.read((byte[])buffer.getData(), 0, this.bufferSize);
                    if (n < 0) {
                        buffer.setEOM(true);
                    } else {
                        buffer.setLength(n);
                    }
                    this.fullQueue.put(buffer);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                try {
                    this.fullQueue.put(iOException);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.setClosed();
            }
        }
    }
}

