/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.apps.mediaserver;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.AbstractDataSink;
import net.sf.fmj.utility.LoggerSingleton;

public class StreamDataSink
extends AbstractDataSink {
    private static final Logger logger = LoggerSingleton.logger;
    private PushDataSource source;
    private WriterThread writerThread;
    private final OutputStream os;

    public StreamDataSink(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public Object getControl(String string) {
        logger.warning("TODO: getControl " + string);
        return null;
    }

    public Object[] getControls() {
        logger.warning("TODO: getControls");
        return new Object[0];
    }

    public void open() throws IOException, SecurityException {
        PushSourceStream[] pushSourceStreamArray = this.source.getStreams();
        this.source.connect();
        this.writerThread = new WriterThread(this.source.getStreams()[0], this.os);
        this.writerThread.setName("WriterThread for " + this.os);
        this.writerThread.setDaemon(true);
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        logger.finer("setSource: " + dataSource);
        if (!(dataSource instanceof PushDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushDataSource)dataSource;
    }

    public void start() throws IOException {
        this.source.start();
        this.writerThread.start();
    }

    public void stop() throws IOException {
        if (this.writerThread != null) {
            this.writerThread.close();
            try {
                this.writerThread.waitUntilClosed();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            finally {
                this.writerThread = null;
            }
        }
        if (this.source != null) {
            this.source.stop();
        }
    }

    private class WriterThread
    extends CloseableThread
    implements SourceTransferHandler {
        private final PushSourceStream sourceStream;
        private final OutputStream os;
        private SynchronizedBoolean dataAvailable = new SynchronizedBoolean();
        private static final boolean USE_TRANSFER_HANDLER = true;
        private static final int DEFAULT_BUFFER_SIZE = 10000;

        public WriterThread(PushSourceStream pushSourceStream, OutputStream outputStream) {
            this.sourceStream = pushSourceStream;
            this.os = outputStream;
            pushSourceStream.setTransferHandler(this);
        }

        public boolean isRandomAccess() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                logger.fine("getMinimumTransferSize: " + this.sourceStream.getMinimumTransferSize());
                byte[] byArray = new byte[this.sourceStream.getMinimumTransferSize() > 10000 ? this.sourceStream.getMinimumTransferSize() : 10000];
                boolean bl = false;
                block10: while (!this.isClosing() && !bl) {
                    int n;
                    SynchronizedBoolean synchronizedBoolean = this.dataAvailable;
                    synchronized (synchronizedBoolean) {
                        this.dataAvailable.waitUntil(true);
                        this.dataAvailable.setValue(false);
                    }
                    while ((n = this.sourceStream.read(byArray, 0, byArray.length)) != 0) {
                        if (n < 0) {
                            bl = true;
                            this.os.close();
                            logger.fine("EOS");
                            StreamDataSink.this.notifyDataSinkListeners(new EndOfStreamEvent(StreamDataSink.this, "EOS"));
                            continue block10;
                        }
                        this.os.write(byArray, 0, n);
                    }
                }
                if (!bl) {
                    logger.warning("Closed before EOS");
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                StreamDataSink.this.notifyDataSinkListeners(new DataSinkErrorEvent(StreamDataSink.this, iOException.getMessage()));
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.WARNING, "" + interruptedException, interruptedException);
            }
            finally {
                this.setClosed();
            }
        }

        public void transferData(PushSourceStream pushSourceStream) {
            this.dataAvailable.setValue(true);
        }
    }
}

