/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils.synchronization;

import com.lti.utils.collections.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerConsumerQueue<T> {
    private final Queue<T> q = new Queue();
    private final int sizeLimit;

    public ProducerConsumerQueue() {
        this.sizeLimit = -1;
    }

    public ProducerConsumerQueue(int n) {
        this.sizeLimit = n;
    }

    public synchronized T get() throws InterruptedException {
        while (this.q.isEmpty()) {
            this.wait();
        }
        T t = this.q.dequeue();
        this.notifyAll();
        return t;
    }

    public synchronized T get(long l, T t) throws InterruptedException {
        while (this.q.isEmpty()) {
            long l2 = System.currentTimeMillis();
            this.wait(l);
            if (System.currentTimeMillis() - l2 <= l) continue;
            return t;
        }
        T t2 = this.q.dequeue();
        this.notifyAll();
        return t2;
    }

    public synchronized boolean isEmpty() {
        return this.q.size() == 0;
    }

    public synchronized boolean isFull() {
        return this.sizeLimit > 0 && this.q.size() >= this.sizeLimit;
    }

    public synchronized void put(T t) throws InterruptedException {
        while (this.sizeLimit > 0 && this.q.size() >= this.sizeLimit) {
            this.wait();
        }
        this.q.enqueue(t);
        this.notifyAll();
    }

    public synchronized boolean put(T t, long l) throws InterruptedException {
        while (this.sizeLimit > 0 && this.q.size() >= this.sizeLimit) {
            long l2 = System.currentTimeMillis();
            this.wait(l);
            if (System.currentTimeMillis() - l2 <= l) continue;
            return false;
        }
        this.q.enqueue(t);
        this.notifyAll();
        return true;
    }

    public synchronized int size() {
        return this.q.size();
    }

    public int sizeLimit() {
        return this.sizeLimit;
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.q.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilNotEmpty() throws InterruptedException {
        while (this.q.isEmpty()) {
            this.wait();
        }
    }

    public synchronized boolean waitUntilNotEmpty(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        while (this.q.isEmpty()) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            long l5 = l - l4;
            if (l5 < 1L) {
                return false;
            }
            this.wait(l5);
        }
        return !this.q.isEmpty();
    }
}

