/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public final class ClientInitialMembershipEvent
implements IdentifiedDataSerializable {
    public static final int MEMBER_ADDED = 1;
    public static final int MEMBER_REMOVED = 2;
    public static final int INITIAL_MEMBERS = 3;
    public static final int MEMBER_ATTRIBUTE_CHANGED = 5;
    private Member member;
    private MemberAttributeChange memberAttributeChange;
    private int eventType;
    private Collection<MemberImpl> memberList;

    public ClientInitialMembershipEvent() {
    }

    public ClientInitialMembershipEvent(Member member, int eventType) {
        this.member = member;
        this.eventType = eventType;
    }

    public ClientInitialMembershipEvent(Member member, MemberAttributeChange memberAttributeChange) {
        this.member = member;
        this.eventType = 5;
        this.memberAttributeChange = memberAttributeChange;
    }

    public ClientInitialMembershipEvent(Collection<MemberImpl> members) {
        this.eventType = 3;
        this.memberList = members;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Member getMember() {
        return this.member;
    }

    public MemberAttributeChange getMemberAttributeChange() {
        return this.memberAttributeChange;
    }

    public Collection<MemberImpl> getMembers() {
        if (this.eventType != 3) {
            return null;
        }
        return this.memberList;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.eventType);
        if (this.eventType == 3) {
            out.writeInt(this.memberList.size());
            for (MemberImpl member : this.memberList) {
                member.writeData(out);
            }
            return;
        }
        this.member.writeData(out);
        if (this.eventType == 5) {
            this.memberAttributeChange.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readInt();
        if (this.eventType == 3) {
            int memberListSize = in.readInt();
            this.memberList = new LinkedList<MemberImpl>();
            for (int i = 0; i < memberListSize; ++i) {
                MemberImpl m = new MemberImpl();
                m.readData(in);
                this.memberList.add(m);
            }
            return;
        }
        this.member = new MemberImpl();
        this.member.readData(in);
        if (this.eventType == 5) {
            this.memberAttributeChange = new MemberAttributeChange();
            this.memberAttributeChange.readData(in);
        }
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 9;
    }
}

