/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class EC5Util {
    static EllipticCurve convertCurve(ECCurve eCCurve, byte[] byArray) {
        if (eCCurve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)eCCurve).getQ()), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
        }
        ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
        if (f2m.isTrinomial()) {
            int[] nArray = new int[]{f2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
        }
        int[] nArray = new int[]{f2m.getK3(), f2m.getK2(), f2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
    }

    static ECParameterSpec convertSpec(EllipticCurve ellipticCurve, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            return new ECNamedCurveSpec(((ECNamedCurveParameterSpec)eCParameterSpec).getName(), ellipticCurve, new ECPoint(eCParameterSpec.getG().getX().toBigInteger(), eCParameterSpec.getG().getY().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH());
        }
        return new ECParameterSpec(ellipticCurve, new ECPoint(eCParameterSpec.getG().getX().toBigInteger(), eCParameterSpec.getG().getY().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
    }

    static org.bouncycastle.jce.spec.ECParameterSpec convertSpec(ECParameterSpec eCParameterSpec, boolean bl) {
        org.bouncycastle.math.ec.ECPoint eCPoint;
        ECCurve eCCurve;
        ECField eCField = eCParameterSpec.getCurve().getField();
        if (eCField instanceof ECFieldFp) {
            eCCurve = new ECCurve.Fp(((ECFieldFp)eCParameterSpec.getCurve().getField()).getP(), eCParameterSpec.getCurve().getA(), eCParameterSpec.getCurve().getB());
            eCPoint = new ECPoint.Fp(eCCurve, new ECFieldElement.Fp(eCCurve.getQ(), eCParameterSpec.getGenerator().getAffineX()), new ECFieldElement.Fp(eCCurve.getQ(), eCParameterSpec.getGenerator().getAffineY()), bl);
        } else {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            int n = eCFieldF2m.getM();
            int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
            eCCurve = new ECCurve.F2m(n, nArray[0], nArray[1], nArray[2], eCParameterSpec.getCurve().getA(), eCParameterSpec.getCurve().getB());
            eCPoint = new ECPoint.F2m(eCCurve, new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[2], eCParameterSpec.getGenerator().getAffineX()), new ECFieldElement.F2m(n, nArray[0], nArray[1], nArray[2], eCParameterSpec.getGenerator().getAffineY()), bl);
        }
        return new org.bouncycastle.jce.spec.ECParameterSpec(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()), eCParameterSpec.getCurve().getSeed());
    }
}

