/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.util.Collection;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.videobridge.stats.Statistics;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JSONSerializer {
    static final String CANDIDATE_LIST = "candidates";
    static final String CHANNEL_BUNDLES = "channel-bundles";
    static final String CHANNELS = "channels";
    static final String CONTENTS = "contents";
    static final String FINGERPRINTS = "fingerprints";
    static final String PARAMETERS = "parameters";
    static final String PAYLOAD_TYPES = "payload-types";
    static final String SCTP_CONNECTIONS = "sctpconnections";
    static final String SOURCE_GROUPS = "ssrc-groups";
    static final String SOURCES = "sources";
    static final String SSRCS = "ssrcs";
    static final String XMLNS = "xmlns";

    public static void serializeAbstractPacketExtensionAttributes(AbstractPacketExtension abstractPacketExtension, JSONObject jsonObject) {
        for (String name : abstractPacketExtension.getAttributeNames()) {
            Object value = abstractPacketExtension.getAttribute(name);
            if (value instanceof Enum) {
                value = value.toString();
            }
            jsonObject.put((Object)name, value);
        }
    }

    public static JSONObject serializeCandidate(CandidatePacketExtension candidate) {
        JSONObject candidateJSONObject;
        if (candidate == null) {
            candidateJSONObject = null;
        } else {
            candidateJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)candidate, candidateJSONObject);
        }
        return candidateJSONObject;
    }

    public static JSONArray serializeCandidates(Collection<CandidatePacketExtension> candidates) {
        JSONArray candidatesJSONArray;
        if (candidates == null) {
            candidatesJSONArray = null;
        } else {
            candidatesJSONArray = new JSONArray();
            for (CandidatePacketExtension candidate : candidates) {
                candidatesJSONArray.add((Object)JSONSerializer.serializeCandidate(candidate));
            }
        }
        return candidatesJSONArray;
    }

    public static JSONObject serializeChannel(ColibriConferenceIQ.Channel channel) {
        JSONObject jsonObject;
        if (channel == null) {
            jsonObject = null;
        } else {
            MediaDirection direction = channel.getDirection();
            Integer lastN = channel.getLastN();
            List payloadTypes = channel.getPayloadTypes();
            Integer receivingSimulcastLayer = channel.getReceivingSimulcastLayer();
            RTPLevelRelayType rtpLevelRelayType = channel.getRTPLevelRelayType();
            List sources = channel.getSources();
            List sourceGroups = channel.getSourceGroups();
            int[] ssrcs = channel.getSSRCs();
            jsonObject = JSONSerializer.serializeChannelCommon((ColibriConferenceIQ.ChannelCommon)channel);
            if (direction != null) {
                jsonObject.put((Object)"direction", (Object)direction.toString());
            }
            if (lastN != null) {
                jsonObject.put((Object)"last-n", (Object)lastN);
            }
            if (lastN != null) {
                jsonObject.put((Object)"receive-simulcast-layer", (Object)receivingSimulcastLayer);
            }
            if (payloadTypes != null && !payloadTypes.isEmpty()) {
                jsonObject.put((Object)PAYLOAD_TYPES, (Object)JSONSerializer.serializePayloadTypes(payloadTypes));
            }
            if (rtpLevelRelayType != null) {
                jsonObject.put((Object)"rtp-level-relay-type", (Object)rtpLevelRelayType.toString());
            }
            if (sources != null && !sources.isEmpty()) {
                jsonObject.put((Object)SOURCES, (Object)JSONSerializer.serializeSources(sources));
            }
            if (sourceGroups != null && !sourceGroups.isEmpty()) {
                jsonObject.put((Object)SOURCE_GROUPS, (Object)JSONSerializer.serializeSourceGroups(sourceGroups));
            }
            if (ssrcs != null && ssrcs.length > 0) {
                jsonObject.put((Object)SSRCS, (Object)JSONSerializer.serializeSSRCs(ssrcs));
            }
        }
        return jsonObject;
    }

    public static JSONObject serializeChannelBundle(ColibriConferenceIQ.ChannelBundle channelBundle) {
        JSONObject jsonObject;
        if (channelBundle == null) {
            jsonObject = null;
        } else {
            String id = channelBundle.getId();
            IceUdpTransportPacketExtension transport = channelBundle.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (transport != null) {
                jsonObject.put((Object)transport.getElementName(), (Object)JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannelBundles(Collection<ColibriConferenceIQ.ChannelBundle> channelBundles) {
        JSONArray jsonArray;
        if (channelBundles == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.ChannelBundle channelBundle : channelBundles) {
                jsonArray.add((Object)JSONSerializer.serializeChannelBundle(channelBundle));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeChannelCommon(ColibriConferenceIQ.ChannelCommon channelCommon) {
        JSONObject jsonObject;
        if (channelCommon == null) {
            jsonObject = null;
        } else {
            String id = channelCommon.getID();
            String channelBundleId = channelCommon.getChannelBundleId();
            String endpoint = channelCommon.getEndpoint();
            int expire = channelCommon.getExpire();
            Boolean initiator = channelCommon.isInitiator();
            IceUdpTransportPacketExtension transport = channelCommon.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (channelBundleId != null) {
                jsonObject.put((Object)"channel-bundle-id", (Object)channelBundleId);
            }
            if (endpoint != null) {
                jsonObject.put((Object)"endpoint", (Object)endpoint);
            }
            if (expire >= 0) {
                jsonObject.put((Object)"expire", (Object)expire);
            }
            if (initiator != null) {
                jsonObject.put((Object)"initiator", (Object)initiator);
            }
            if (transport != null) {
                jsonObject.put((Object)transport.getElementName(), (Object)JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannels(Collection<ColibriConferenceIQ.Channel> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Channel element : collection) {
                jsonArray.add((Object)JSONSerializer.serializeChannel(element));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeConference(ColibriConferenceIQ conference) {
        JSONObject jsonObject;
        if (conference == null) {
            jsonObject = null;
        } else {
            String id = conference.getID();
            List contents = conference.getContents();
            List channelBundles = conference.getChannelBundles();
            ColibriConferenceIQ.Recording recording = conference.getRecording();
            boolean isGracefulShutdown = conference.isGracefulShutdown();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (contents != null && !contents.isEmpty()) {
                jsonObject.put((Object)CONTENTS, (Object)JSONSerializer.serializeContents(contents));
            }
            if (channelBundles != null && !channelBundles.isEmpty()) {
                jsonObject.put((Object)CHANNEL_BUNDLES, (Object)JSONSerializer.serializeChannelBundles(channelBundles));
            }
            if (recording != null) {
                jsonObject.put((Object)"recording", (Object)JSONSerializer.serializeRecording(recording));
            }
            if (isGracefulShutdown) {
                jsonObject.put((Object)"graceful-shutdown", (Object)"true");
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeConferences(Collection<ColibriConferenceIQ> conferences) {
        JSONArray conferencesJSONArray;
        if (conferences == null) {
            conferencesJSONArray = null;
        } else {
            conferencesJSONArray = new JSONArray();
            for (ColibriConferenceIQ conference : conferences) {
                conferencesJSONArray.add((Object)JSONSerializer.serializeConference(conference));
            }
        }
        return conferencesJSONArray;
    }

    public static JSONObject serializeContent(ColibriConferenceIQ.Content content) {
        JSONObject jsonObject;
        if (content == null) {
            jsonObject = null;
        } else {
            String name = content.getName();
            List channels = content.getChannels();
            List sctpConnections = content.getSctpConnections();
            jsonObject = new JSONObject();
            if (name != null) {
                jsonObject.put((Object)"name", (Object)name);
            }
            if (channels != null && !channels.isEmpty()) {
                jsonObject.put((Object)CHANNELS, (Object)JSONSerializer.serializeChannels(channels));
            }
            if (sctpConnections != null && !sctpConnections.isEmpty()) {
                jsonObject.put((Object)SCTP_CONNECTIONS, (Object)JSONSerializer.serializeSctpConnections(sctpConnections));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeContents(Collection<ColibriConferenceIQ.Content> contents) {
        JSONArray jsonArray;
        if (contents == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Content content : contents) {
                jsonArray.add((Object)JSONSerializer.serializeContent(content));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeFingerprint(DtlsFingerprintPacketExtension fingerprint) {
        JSONObject fingerprintJSONObject;
        if (fingerprint == null) {
            fingerprintJSONObject = null;
        } else {
            String theFingerprint = fingerprint.getFingerprint();
            fingerprintJSONObject = new JSONObject();
            if (theFingerprint != null) {
                fingerprintJSONObject.put((Object)fingerprint.getElementName(), (Object)theFingerprint);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)fingerprint, fingerprintJSONObject);
        }
        return fingerprintJSONObject;
    }

    public static JSONArray serializeFingerprints(Collection<DtlsFingerprintPacketExtension> fingerprints) {
        JSONArray fingerprintsJSONArray;
        if (fingerprints == null) {
            fingerprintsJSONArray = null;
        } else {
            fingerprintsJSONArray = new JSONArray();
            for (DtlsFingerprintPacketExtension fingerprint : fingerprints) {
                fingerprintsJSONArray.add((Object)JSONSerializer.serializeFingerprint(fingerprint));
            }
        }
        return fingerprintsJSONArray;
    }

    public static JSONObject serializeParameters(Collection<ParameterPacketExtension> parameters) {
        JSONObject parametersJSONObject;
        if (parameters == null) {
            parametersJSONObject = null;
        } else {
            parametersJSONObject = new JSONObject();
            for (ParameterPacketExtension parameter : parameters) {
                String name = parameter.getName();
                String value = parameter.getValue();
                if (name == null && value == null) continue;
                parametersJSONObject.put((Object)name, (Object)value);
            }
        }
        return parametersJSONObject;
    }

    public static JSONObject serializePayloadType(PayloadTypePacketExtension payloadType) {
        JSONObject payloadTypeJSONObject;
        if (payloadType == null) {
            payloadTypeJSONObject = null;
        } else {
            List parameters = payloadType.getParameters();
            payloadTypeJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)payloadType, payloadTypeJSONObject);
            if (parameters != null && !parameters.isEmpty()) {
                payloadTypeJSONObject.put((Object)PARAMETERS, (Object)JSONSerializer.serializeParameters(parameters));
            }
        }
        return payloadTypeJSONObject;
    }

    public static JSONObject serializeRecording(ColibriConferenceIQ.Recording recording) {
        String directory;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"state", (Object)recording.getState());
        String token = recording.getToken();
        if (token != null) {
            jsonObject.put((Object)"token", (Object)token);
        }
        if ((directory = recording.getDirectory()) != null) {
            jsonObject.put((Object)"directory", (Object)directory);
        }
        return jsonObject;
    }

    public static JSONArray serializePayloadTypes(Collection<PayloadTypePacketExtension> payloadTypes) {
        JSONArray payloadTypesJSONArray;
        if (payloadTypes == null) {
            payloadTypesJSONArray = null;
        } else {
            payloadTypesJSONArray = new JSONArray();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                payloadTypesJSONArray.add((Object)JSONSerializer.serializePayloadType(payloadType));
            }
        }
        return payloadTypesJSONArray;
    }

    public static JSONObject serializeSctpConnection(ColibriConferenceIQ.SctpConnection sctpConnection) {
        JSONObject jsonObject;
        if (sctpConnection == null) {
            jsonObject = null;
        } else {
            int port = sctpConnection.getPort();
            jsonObject = JSONSerializer.serializeChannelCommon((ColibriConferenceIQ.ChannelCommon)sctpConnection);
            jsonObject.put((Object)"port", (Object)port);
        }
        return jsonObject;
    }

    public static JSONArray serializeSctpConnections(Collection<ColibriConferenceIQ.SctpConnection> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.SctpConnection element : collection) {
                jsonArray.add((Object)JSONSerializer.serializeSctpConnection(element));
            }
        }
        return jsonArray;
    }

    public static Long serializeSource(SourcePacketExtension source) {
        return source == null ? null : Long.valueOf(source.getSSRC());
    }

    private static Object serializeSourceGroup(SourceGroupPacketExtension sourceGroup) {
        if (sourceGroup.getSemantics() != null && sourceGroup.getSemantics().length() != 0 && sourceGroup.getSources() != null && sourceGroup.getSources().size() != 0) {
            JSONObject sourceGroupJSONObject = new JSONObject();
            sourceGroupJSONObject.put((Object)"semantics", (Object)JSONValue.escape((String)sourceGroup.getSemantics()));
            JSONArray ssrcsJSONArray = new JSONArray();
            for (SourcePacketExtension source : sourceGroup.getSources()) {
                ssrcsJSONArray.add((Object)source.getSSRC());
            }
            sourceGroupJSONObject.put((Object)SOURCES, (Object)ssrcsJSONArray);
            return sourceGroupJSONObject;
        }
        return null;
    }

    public static JSONArray serializeSourceGroups(Collection<SourceGroupPacketExtension> sourceGroups) {
        JSONArray sourceGroupsJSONArray;
        if (sourceGroups == null || sourceGroups.size() == 0) {
            sourceGroupsJSONArray = null;
        } else {
            sourceGroupsJSONArray = new JSONArray();
            for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                sourceGroupsJSONArray.add(JSONSerializer.serializeSourceGroup(sourceGroup));
            }
        }
        return sourceGroupsJSONArray;
    }

    public static JSONArray serializeSources(Collection<SourcePacketExtension> sources) {
        JSONArray sourcesJSONArray;
        if (sources == null) {
            sourcesJSONArray = null;
        } else {
            sourcesJSONArray = new JSONArray();
            for (SourcePacketExtension source : sources) {
                sourcesJSONArray.add((Object)JSONSerializer.serializeSource(source));
            }
        }
        return sourcesJSONArray;
    }

    public static JSONArray serializeSSRCs(int[] ssrcs) {
        JSONArray ssrcsJSONArray;
        if (ssrcs == null) {
            ssrcsJSONArray = null;
        } else {
            ssrcsJSONArray = new JSONArray();
            for (int i = 0; i < ssrcs.length; ++i) {
                ssrcsJSONArray.add((Object)((long)ssrcs[i] & 0xFFFFFFFFL));
            }
        }
        return ssrcsJSONArray;
    }

    public static JSONObject serializeStatistics(Statistics statistics) {
        JSONObject statisticsJSONObject = statistics == null ? null : new JSONObject(statistics.getStats());
        return statisticsJSONObject;
    }

    public static JSONObject serializeTransport(IceUdpTransportPacketExtension transport) {
        JSONObject jsonObject;
        if (transport == null) {
            jsonObject = null;
        } else {
            String xmlns = transport.getNamespace();
            List fingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            List candidateList = transport.getCandidateList();
            RemoteCandidatePacketExtension remoteCandidate = transport.getRemoteCandidate();
            boolean rtcpMux = transport.isRtcpMux();
            jsonObject = new JSONObject();
            if (xmlns != null) {
                jsonObject.put((Object)XMLNS, (Object)xmlns);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)transport, jsonObject);
            if (fingerprints != null && !fingerprints.isEmpty()) {
                jsonObject.put((Object)FINGERPRINTS, (Object)JSONSerializer.serializeFingerprints(fingerprints));
            }
            if (candidateList != null && !candidateList.isEmpty()) {
                jsonObject.put((Object)CANDIDATE_LIST, (Object)JSONSerializer.serializeCandidates(candidateList));
            }
            if (remoteCandidate != null) {
                jsonObject.put((Object)remoteCandidate.getElementName(), (Object)JSONSerializer.serializeCandidate((CandidatePacketExtension)remoteCandidate));
            }
            if (rtcpMux) {
                jsonObject.put((Object)"rtcp-mux", (Object)rtcpMux);
            }
        }
        return jsonObject;
    }

    private JSONSerializer() {
    }
}

