/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.babel.examples.interpreter.Context;
import weblogic.xml.babel.examples.interpreter.Expression;
import weblogic.xml.babel.parsers.BabelXMLEventStream;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.XMLEventStream;

public class BooleanInterpreter {
    private Map expressions = new HashMap();
    private Map contexts = new HashMap();
    private static final String docName = "BooleanInterpreter";
    static final boolean verbose = false;

    private void addExpression(Expression expression) {
        this.expressions.put(expression.getName(), expression);
    }

    public Context lookupContext(String string) {
        return (Context)this.contexts.get(string);
    }

    public Expression lookupExpression(String string) {
        return (Expression)this.expressions.get(string);
    }

    public void addContext(Context context) {
        this.contexts.put(context.getName(), context);
    }

    public static String getArgument(String string, StartElementEvent startElementEvent) {
        Attributes attributes = startElementEvent.getAttributes();
        return attributes.getValue(string);
    }

    public static String getFirstArgument(StartElementEvent startElementEvent) {
        return BooleanInterpreter.getArgument(startElementEvent, 0);
    }

    public static String getSecondArgument(StartElementEvent startElementEvent) {
        return BooleanInterpreter.getArgument(startElementEvent, 1);
    }

    public static String getArgument(StartElementEvent startElementEvent, int n) {
        Attributes attributes = startElementEvent.getAttributes();
        return attributes.getValue(n);
    }

    public void readState(XMLEventStream xMLEventStream) throws SAXException {
        Object object;
        StartElementEvent startElementEvent;
        do {
            startElementEvent = xMLEventStream.startElement("expression");
            object = new Expression();
            ((Expression)object).setName(BooleanInterpreter.getArgument("id", startElementEvent));
            ((Expression)object).read(xMLEventStream);
            this.addExpression((Expression)object);
            System.out.println("Read[" + ((Expression)object).getName() + "]=" + object);
        } while (xMLEventStream.nextElementIs("expression"));
        do {
            startElementEvent = xMLEventStream.getSubStream().startElement();
            object = new Context(BooleanInterpreter.getArgument("id", startElementEvent));
            ((Context)object).read(xMLEventStream);
            this.addContext((Context)object);
            System.out.println("Variables bound in [" + ((Context)object).getName() + "] " + object);
        } while (xMLEventStream.nextElementIs("context"));
    }

    public void evaluate(XMLEventStream xMLEventStream) throws SAXException {
        StartElementEvent startElementEvent = xMLEventStream.startElement("interpret");
        String string = BooleanInterpreter.getArgument("context", startElementEvent);
        String string2 = BooleanInterpreter.getArgument("expression", startElementEvent);
        Context context = this.lookupContext(string);
        Expression expression = this.lookupExpression(string2);
        boolean bl = expression.evaluate(context);
        System.out.println("Interpreted expression:" + string2 + " in context:" + string + " to " + bl);
    }

    public void replace(XMLEventStream xMLEventStream) throws SAXException {
        StartElementEvent startElementEvent = xMLEventStream.startElement("replace");
        String string = BooleanInterpreter.getArgument("var", startElementEvent);
        String string2 = BooleanInterpreter.getArgument("with_expression", startElementEvent);
        String string3 = BooleanInterpreter.getArgument("in_expression", startElementEvent);
        System.out.println("Replacing variable [" + string + "]");
        Expression expression = this.lookupExpression(string3);
        System.out.println("\tin old expression:[" + expression + "]");
        Expression expression2 = this.lookupExpression(string2);
        System.out.println("\twith new:[" + expression2 + "]");
        expression.replace(string, expression2.getExpression());
        System.out.println("The new expression is:[" + expression + "]");
    }

    public void readEvaluations(XMLEventStream xMLEventStream) throws SAXException {
        xMLEventStream.startElement("evaluate");
        do {
            StartElementEvent startElementEvent;
            if ((startElementEvent = xMLEventStream.getSubStream().startElement()).getName().equals("replace")) {
                this.replace(xMLEventStream);
                continue;
            }
            this.evaluate(xMLEventStream);
        } while (xMLEventStream.nextElementIs("interpret") || xMLEventStream.nextElementIs("replace"));
    }

    public void read(XMLEventStream xMLEventStream) throws SAXException {
        StartElementEvent startElementEvent = xMLEventStream.startElement();
        if (!startElementEvent.getName().equals(docName)) {
            throw new SAXException("This intepreter can only understand BooleanInterpreter XML docs");
        }
        this.readState(xMLEventStream.getSubStream());
        this.readEvaluations(xMLEventStream.getSubStream());
    }

    public static void main(String[] stringArray) throws Exception {
        BooleanInterpreter booleanInterpreter = new BooleanInterpreter();
        BabelXMLEventStream babelXMLEventStream = new BabelXMLEventStream();
        babelXMLEventStream.startDocument(new InputSource(stringArray[0]));
        booleanInterpreter.read((XMLEventStream)babelXMLEventStream);
    }
}

