/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class GetInfoCmd
extends LocCommand {
    public static final long FLAG_INFO = 1L;
    public static final long FLAG_AWAYMSG = 2L;
    public static final long FLAG_CERT = 8L;
    private final long flags;
    private final String sn;

    protected GetInfoCmd(SnacPacket snacPacket) {
        super(21);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.flags = BinaryTools.getUInt(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock2);
        this.sn = stringBlock == null ? null : stringBlock.getString();
    }

    public GetInfoCmd(long l, String string) {
        super(21);
        DefensiveTools.checkRange(l, "flags", -1);
        DefensiveTools.checkNull(string, "sn");
        this.flags = l;
        this.sn = string;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.flags != -1L) {
            BinaryTools.writeUInt(outputStream, this.flags);
            if (this.sn != null) {
                OscarTools.writeScreenname(outputStream, this.sn);
            }
        }
    }

    public String toString() {
        return "GetInfoCmd: flags=" + this.flags + ", sn=" + this.sn;
    }
}

