/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SendImIcbm
extends AbstractImIcbm {
    private static final int TYPE_ACK = 3;
    private final String sn;
    private final boolean ackRequested;

    protected SendImIcbm(SnacPacket snacPacket) {
        super(6, snacPacket);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.processImTlvs(immutableTlvChain);
        this.ackRequested = immutableTlvChain.hasTlv(3);
    }

    public SendImIcbm(String string, String string2) {
        this(string, string2, false);
    }

    public SendImIcbm(String string, String string2, boolean bl) {
        this(string, new InstantMessage(string2), bl, 0L, false, null, null, true);
    }

    public SendImIcbm(String string, String string2, boolean bl, long l, boolean bl2, OldIconHashInfo oldIconHashInfo, ExtraInfoBlock[] extraInfoBlockArray, boolean bl3) {
        this(string, new InstantMessage(string2), bl, l, bl2, oldIconHashInfo, extraInfoBlockArray, bl3);
    }

    public SendImIcbm(String string, InstantMessage instantMessage, boolean bl, long l, boolean bl2, OldIconHashInfo oldIconHashInfo, ExtraInfoBlock[] extraInfoBlockArray, boolean bl3) {
        super(6, l, instantMessage, bl, bl2, oldIconHashInfo, extraInfoBlockArray);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
        this.ackRequested = bl3;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final boolean isAckRequested() {
        return this.ackRequested;
    }

    protected void writeChannelData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        this.writeImTlvs(outputStream);
        if (this.ackRequested) {
            new Tlv(3).write(outputStream);
        }
    }
}

