/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractImIcbm
extends AbstractIcbm {
    private static final int TYPE_MESSAGE = 2;
    private static final int TYPE_ICONINFO = 8;
    private static final int TYPE_AUTO = 4;
    private static final int TYPE_ICON_REQ = 9;
    private static final int TYPE_EXPRESSION_INFO = 13;
    private static final int TYPE_FEATURES = 1281;
    private static final int TYPE_MESSAGE_PARTS = 257;
    private static final int TYPE_ENCRYPTION_CODE = 3329;
    private static final ByteBlock FEATURES_DEFAULT = ByteBlock.wrap(new byte[]{1, 1, 1, 2});
    private InstantMessage message;
    private boolean autoResponse;
    private boolean wantsIcon;
    private OldIconHashInfo iconInfo;
    private ExtraInfoBlock[] expressionInfoBlocks;

    protected AbstractImIcbm(int n, SnacPacket snacPacket) {
        super(4, n, snacPacket);
    }

    final void processImTlvs(TlvChain tlvChain) {
        Object object;
        Writable writable;
        DefensiveTools.checkNull(tlvChain, "chain");
        Tlv tlv = tlvChain.getLastTlv(2);
        Tlv tlv2 = tlvChain.getLastTlv(8);
        this.autoResponse = tlvChain.hasTlv(4);
        this.wantsIcon = tlvChain.hasTlv(9);
        if (tlv != null) {
            writable = TlvTools.readChain(tlv.getData());
            if (writable.hasTlv(3329)) {
                object = writable.getFirstTlv(257);
                ByteBlock byteBlock = ((Tlv)object).getData().subBlock(4);
                int n = writable.getUShort(3329);
                this.message = new InstantMessage(n, byteBlock);
            } else {
                object = new StringBuffer();
                Tlv[] tlvArray = writable.getTlvs(257);
                for (int i = 0; i < tlvArray.length; ++i) {
                    ByteBlock byteBlock = tlvArray[i].getData();
                    int n = BinaryTools.getUShort(byteBlock, 0);
                    int n2 = BinaryTools.getUShort(byteBlock, 2);
                    ByteBlock byteBlock2 = byteBlock.subBlock(4);
                    ImEncodingParams imEncodingParams = new ImEncodingParams(n, n2);
                    String string = ImEncodedString.readImEncodedString(imEncodingParams, byteBlock2);
                    ((StringBuffer)object).append(string);
                }
                this.message = new InstantMessage(((StringBuffer)object).toString());
            }
        } else {
            this.message = null;
        }
        if (tlv2 != null) {
            writable = tlv2.getData();
            this.iconInfo = OldIconHashInfo.readIconHashFromImTlvData((ByteBlock)writable);
        } else {
            this.iconInfo = null;
        }
        writable = tlvChain.getLastTlv(13);
        if (writable != null) {
            object = ((Tlv)writable).getData();
            this.expressionInfoBlocks = ExtraInfoBlock.readExtraInfoBlocks((ByteBlock)object);
        }
    }

    protected AbstractImIcbm(int n, long l, InstantMessage instantMessage, boolean bl, boolean bl2, OldIconHashInfo oldIconHashInfo, ExtraInfoBlock[] extraInfoBlockArray) {
        super(4, n, l, 1);
        extraInfoBlockArray = (ExtraInfoBlock[])DefensiveTools.getNonnullArray(extraInfoBlockArray, "expInfoBlocks");
        this.message = instantMessage;
        this.autoResponse = bl;
        this.wantsIcon = bl2;
        this.iconInfo = oldIconHashInfo;
        this.expressionInfoBlocks = extraInfoBlockArray;
    }

    public final InstantMessage getMessage() {
        return this.message;
    }

    public final boolean isAutoResponse() {
        return this.autoResponse;
    }

    public final boolean senderWantsIcon() {
        return this.wantsIcon;
    }

    public final OldIconHashInfo getIconInfo() {
        return this.iconInfo;
    }

    public ExtraInfoBlock[] getAimExpressionInfo() {
        return this.expressionInfoBlocks == null ? null : (ExtraInfoBlock[])this.expressionInfoBlocks.clone();
    }

    final void writeImTlvs(OutputStream outputStream) throws IOException {
        ByteBlock byteBlock;
        Object object;
        if (this.message != null) {
            Object object2;
            Object object3;
            object = TlvTools.createMutableChain();
            if (this.message.isEncrypted()) {
                object3 = Tlv.getUShortInstance(3329, this.message.getEncryptionCode());
                object2 = ByteBlock.wrap(new byte[]{0, 0, 0, 0});
                ByteBlock byteBlock2 = this.message.getEncryptedData();
                byteBlock = ByteBlock.createByteBlock(new LiveWritable[]{object2, byteBlock2});
                object.addTlv((Tlv)object3);
            } else {
                object3 = new ByteArrayOutputStream();
                object2 = ImEncodedString.encodeString(this.message.getMessage());
                ImEncodingParams imEncodingParams = ((ImEncodedString)object2).getEncoding();
                BinaryTools.writeUShort((OutputStream)object3, imEncodingParams.getCharsetCode());
                BinaryTools.writeUShort((OutputStream)object3, imEncodingParams.getCharsetSubcode());
                ((OutputStream)object3).write(((ImEncodedString)object2).getBytes());
                byteBlock = ByteBlock.wrap(((ByteArrayOutputStream)object3).toByteArray());
            }
            object3 = new Tlv(1281, FEATURES_DEFAULT);
            object2 = new Tlv(257, byteBlock);
            object.addTlv((Tlv)object3);
            object.addTlv((Tlv)object2);
            new Tlv(2, ByteBlock.createByteBlock((LiveWritable)object)).write(outputStream);
        }
        if (this.autoResponse) {
            new Tlv(4).write(outputStream);
        }
        if (this.iconInfo != null) {
            object = new ByteArrayOutputStream(20);
            this.iconInfo.writeToImTlv((OutputStream)object);
            byteBlock = ByteBlock.wrap(((ByteArrayOutputStream)object).toByteArray());
            new Tlv(8, byteBlock).write(outputStream);
        }
        if (this.wantsIcon) {
            new Tlv(9).write(outputStream);
        }
        if (this.expressionInfoBlocks != null) {
            object = ByteBlock.createByteBlock(this.expressionInfoBlocks);
            new Tlv(13, (Writable)object).write(outputStream);
        }
    }
}

