/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snac.CmdType;

public class RateClassInfo
implements Writable {
    private final int rateClass;
    private final long windowSize;
    private final long warnAvg;
    private final long limitedAvg;
    private final long clearAvg;
    private final long disconnectAvg;
    private final long currentAvg;
    private final long max;
    private CmdType[] commands = null;

    public static RateClassInfo readRateClassInfo(ByteBlock byteBlock) {
        if (byteBlock.getLength() < 35) {
            return null;
        }
        return new RateClassInfo(byteBlock);
    }

    private RateClassInfo(ByteBlock byteBlock) {
        this.rateClass = BinaryTools.getUShort(byteBlock, 0);
        this.windowSize = BinaryTools.getUInt(byteBlock, 2);
        this.clearAvg = BinaryTools.getUInt(byteBlock, 6);
        this.warnAvg = BinaryTools.getUInt(byteBlock, 10);
        this.limitedAvg = BinaryTools.getUInt(byteBlock, 14);
        this.disconnectAvg = BinaryTools.getUInt(byteBlock, 18);
        this.currentAvg = BinaryTools.getUInt(byteBlock, 22);
        this.max = BinaryTools.getUInt(byteBlock, 26);
    }

    synchronized void setCommands(CmdType[] cmdTypeArray) {
        this.commands = cmdTypeArray;
    }

    public RateClassInfo(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        DefensiveTools.checkRange(n, "rateClass", 0);
        DefensiveTools.checkRange(l, "windowSize", 0);
        DefensiveTools.checkRange(l2, "clearAvg", 0);
        DefensiveTools.checkRange(l3, "warnAvg", 0);
        DefensiveTools.checkRange(l4, "limitedAvg", 0);
        DefensiveTools.checkRange(l5, "disconnectAvg", 0);
        DefensiveTools.checkRange(l6, "currentAvg", 0);
        DefensiveTools.checkRange(l7, "max", 0);
        this.rateClass = n;
        this.windowSize = l;
        this.clearAvg = l2;
        this.warnAvg = l3;
        this.limitedAvg = l4;
        this.disconnectAvg = l5;
        this.currentAvg = l6;
        this.max = l7;
    }

    public final int getRateClass() {
        return this.rateClass;
    }

    public final long getWindowSize() {
        return this.windowSize;
    }

    public final long getWarnAvg() {
        return this.warnAvg;
    }

    public final long getLimitedAvg() {
        return this.limitedAvg;
    }

    public final long getClearAvg() {
        return this.clearAvg;
    }

    public final long getDisconnectAvg() {
        return this.disconnectAvg;
    }

    public final long getCurrentAvg() {
        return this.currentAvg;
    }

    public final long getMax() {
        return this.max;
    }

    public final synchronized CmdType[] getCommands() {
        return (CmdType[])(this.commands == null ? null : this.commands.clone());
    }

    public long getWritableLength() {
        return 35L;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.rateClass);
        BinaryTools.writeUInt(outputStream, this.windowSize);
        BinaryTools.writeUInt(outputStream, this.clearAvg);
        BinaryTools.writeUInt(outputStream, this.warnAvg);
        BinaryTools.writeUInt(outputStream, this.limitedAvg);
        BinaryTools.writeUInt(outputStream, this.disconnectAvg);
        BinaryTools.writeUInt(outputStream, this.currentAvg);
        BinaryTools.writeUInt(outputStream, this.max);
    }

    public synchronized String toString() {
        return "RateClassInfo for class " + this.rateClass + ", currentAvg=" + this.currentAvg + ", windowSize=" + this.windowSize + ", clearAvg=" + this.clearAvg + ", warnAvg=" + this.warnAvg + ", limitedAvg=" + this.limitedAvg + ", disconnectAvg=" + this.disconnectAvg + ", max=" + this.max + ", families: " + (this.commands == null ? "none" : "" + this.commands.length);
    }
}

