/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public final class ExtraInfoData
implements Writable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_HASH_PRESENT = 1;
    public static final int FLAG_UPLOAD_ICON = 64;
    public static final int FLAG_ALREADY_HAVE_ICON = 128;
    public static final int FLAG_AVAILMSG_PRESENT = 4;
    public static final ByteBlock HASH_SPECIAL = ByteBlock.wrap(new byte[]{2, 1, -46, 4, 114});
    private final int flags;
    private final ByteBlock data;
    private final int totalSize;

    public static ExtraInfoData readExtraInfoData(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        short s2 = BinaryTools.getUByte(byteBlock, 1);
        if (byteBlock.getLength() < s2 + 2) {
            return null;
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(2, s2);
        return new ExtraInfoData(s, byteBlock2, 2 + s2);
    }

    private ExtraInfoData(int n, ByteBlock byteBlock, int n2) throws IllegalArgumentException {
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        DefensiveTools.checkRange(byteBlock.getLength(), "data length", 0, 255);
        this.flags = n;
        this.data = byteBlock;
        this.totalSize = n2;
    }

    public ExtraInfoData(int n, ByteBlock byteBlock) throws IllegalArgumentException {
        this(n, byteBlock, -1);
    }

    public final int getFlags() {
        return this.flags;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 2L + (this.data == null ? 0L : this.data.getWritableLength());
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.flags);
        if (this.data != null) {
            BinaryTools.writeUByte(outputStream, this.data.getLength());
            this.data.write(outputStream);
        }
    }

    public String toString() {
        return "ExtraInfoData: flags=0x" + Integer.toHexString(this.flags) + ", data=" + BinaryTools.describeData(this.data);
    }
}

