/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flapcmd.SnacCommand;

public final class SnacPacket
implements LiveWritable {
    private final SnacCommand snacCommand;
    private final int family;
    private final int command;
    private final long reqid;
    private final short flag1;
    private final short flag2;
    private final ByteBlock block;

    static boolean isValidSnacPacket(ByteBlock byteBlock) {
        return byteBlock.getLength() >= 10;
    }

    static SnacPacket readSnacPacket(ByteBlock byteBlock) {
        if (!SnacPacket.isValidSnacPacket(byteBlock)) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        int n2 = BinaryTools.getUShort(byteBlock, 2);
        short s = BinaryTools.getUByte(byteBlock, 4);
        short s2 = BinaryTools.getUByte(byteBlock, 5);
        long l = BinaryTools.getUInt(byteBlock, 6);
        ByteBlock byteBlock2 = byteBlock.subBlock(10);
        return new SnacPacket(n, n2, l, s, s2, byteBlock2);
    }

    public SnacPacket(int n, int n2, long l, short s, short s2, ByteBlock byteBlock) {
        DefensiveTools.checkRange(n, "family", 0);
        DefensiveTools.checkRange(n2, "command", 0);
        DefensiveTools.checkRange(l, "reqid", 0);
        DefensiveTools.checkRange(s, "flag1", 0);
        DefensiveTools.checkRange(s2, "flag2", 0);
        DefensiveTools.checkNull(byteBlock, "data");
        this.snacCommand = null;
        this.family = n;
        this.command = n2;
        this.reqid = l;
        this.flag1 = s;
        this.flag2 = s2;
        this.block = byteBlock;
    }

    SnacPacket(long l, SnacCommand snacCommand) {
        DefensiveTools.checkRange(l, "reqid", 0);
        DefensiveTools.checkNull(snacCommand, "command");
        this.snacCommand = snacCommand;
        this.family = snacCommand.getFamily();
        this.command = snacCommand.getCommand();
        this.reqid = l;
        this.flag1 = snacCommand.getFlag1();
        this.flag2 = snacCommand.getFlag2();
        this.block = null;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public final long getReqid() {
        return this.reqid;
    }

    public final short getFlag1() {
        return this.flag1;
    }

    public final short getFlag2() {
        return this.flag2;
    }

    public final ByteBlock getData() {
        return this.block;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.family);
        BinaryTools.writeUShort(outputStream, this.command);
        BinaryTools.writeUByte(outputStream, this.flag1);
        BinaryTools.writeUByte(outputStream, this.flag2);
        BinaryTools.writeUInt(outputStream, this.reqid);
        if (this.snacCommand != null) {
            this.snacCommand.writeData(outputStream);
        } else if (this.block != null) {
            this.block.write(outputStream);
        }
    }

    public String toString() {
        return "SnacPacket type 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command) + (this.flag1 == 0 ? "" : ", flag1=0x" + Integer.toHexString(this.flag1)) + (this.flag2 == 0 ? "" : ", flag2=0x" + Integer.toHexString(this.flag2)) + ": " + (this.block == null ? null : this.block.getLength() + " bytes") + " (id=" + this.reqid + ")";
    }
}

