/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapDataLengthException;
import net.kano.joscar.flap.FlapHeader;

public final class FlapPacket
implements LiveWritable {
    public static final int CHANNEL_LOGIN = 1;
    public static final int CHANNEL_SNAC = 2;
    public static final int CHANNEL_ERROR = 3;
    public static final int CHANNEL_CLOSE = 4;
    public static final int MAX_DATA_LEN = 65535;
    private final int seqnum;
    private final int channel;
    private ByteBlock block = null;
    private final FlapCommand command;

    static FlapPacket readRestOfFlap(FlapHeader flapHeader, InputStream inputStream) throws IOException {
        int n;
        DefensiveTools.checkNull(flapHeader, "header");
        DefensiveTools.checkNull(inputStream, "in");
        byte[] byArray = new byte[flapHeader.getDataLength()];
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            return null;
        }
        return new FlapPacket(flapHeader, ByteBlock.wrap(byArray));
    }

    FlapPacket(FlapHeader flapHeader, ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(flapHeader, "header");
        DefensiveTools.checkNull(byteBlock, "data");
        if (flapHeader.getDataLength() != byteBlock.getLength()) {
            throw new IllegalArgumentException("FLAP data length (" + byteBlock.getLength() + ") does not agree with header (" + flapHeader.getDataLength() + ")");
        }
        this.channel = flapHeader.getChannel();
        this.seqnum = flapHeader.getSeqnum();
        this.block = byteBlock;
        this.command = null;
    }

    FlapPacket(int n, FlapCommand flapCommand) {
        DefensiveTools.checkNull(flapCommand, "command");
        this.seqnum = n;
        this.channel = flapCommand.getChannel();
        this.block = null;
        this.command = flapCommand;
    }

    public final int getSeqnum() {
        return this.seqnum;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final synchronized ByteBlock getData() {
        return this.block;
    }

    public synchronized void write(OutputStream outputStream) throws FlapDataLengthException, IOException {
        int n;
        if (this.block == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.command.writeData(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.block = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
        }
        if ((n = (int)this.block.getWritableLength()) > 65535) {
            throw new FlapDataLengthException("data length (" + n + ") must " + "be <= " + 65535);
        }
        BinaryTools.writeUByte(outputStream, 42);
        BinaryTools.writeUByte(outputStream, this.channel);
        BinaryTools.writeUShort(outputStream, this.seqnum);
        BinaryTools.writeUShort(outputStream, n);
        this.block.write(outputStream);
    }

    public String toString() {
        return "FlapPacket (channel=" + this.channel + ", seq=" + this.seqnum + ")";
    }
}

