/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public class ParamInfo
implements Writable {
    public static final int MAXCHAN_DEFAULT = 0;
    public static final long FLAG_CHANMSGS_ALLOWED = 1L;
    public static final long FLAG_MISSEDCALLS_ALLOWED = 2L;
    public static final long FLAG_TYPING_NOTIFICATION = 16L;
    private final int maxChannel;
    private final long flags;
    private final int maxMsgLen;
    private final int maxSenderWarning;
    private final int maxReceiverWarning;
    private final long minMsgInterval;

    protected static ParamInfo readParamInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 16) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        long l = BinaryTools.getUInt(byteBlock, 2);
        int n2 = BinaryTools.getUShort(byteBlock, 6);
        int n3 = BinaryTools.getUShort(byteBlock, 8);
        int n4 = BinaryTools.getUShort(byteBlock, 10);
        long l2 = BinaryTools.getUInt(byteBlock, 12);
        return new ParamInfo(n, l, n2, n3, n4, l2);
    }

    public ParamInfo(long l, int n, int n2, int n3, long l2) {
        this(0, l, n, n2, n3, l2);
    }

    public ParamInfo(int n, long l, int n2, int n3, int n4, long l2) {
        DefensiveTools.checkRange(n, "maxChannel", 0);
        DefensiveTools.checkRange(l, "flags", 0);
        DefensiveTools.checkRange(n2, "maxMsgLen", 0);
        DefensiveTools.checkRange(n3, "maxSenderWarning", 0);
        DefensiveTools.checkRange(n4, "maxReceiverWarning", 0);
        DefensiveTools.checkRange(l2, "minMsgInterval", 0);
        this.maxChannel = n;
        this.flags = l;
        this.maxMsgLen = n2;
        this.maxSenderWarning = n3;
        this.maxReceiverWarning = n4;
        this.minMsgInterval = l2;
    }

    public final int getMaxChannel() {
        return this.maxChannel;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getMaxMsgLen() {
        return this.maxMsgLen;
    }

    public final int getMaxSenderWarning() {
        return this.maxSenderWarning;
    }

    public final int getMaxReceiverWarning() {
        return this.maxReceiverWarning;
    }

    public final long getMinMsgInterval() {
        return this.minMsgInterval;
    }

    public long getWritableLength() {
        return 16L;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.maxChannel);
        BinaryTools.writeUInt(outputStream, this.flags);
        BinaryTools.writeUShort(outputStream, this.maxMsgLen);
        BinaryTools.writeUShort(outputStream, this.maxSenderWarning);
        BinaryTools.writeUShort(outputStream, this.maxReceiverWarning);
        BinaryTools.writeUInt(outputStream, this.minMsgInterval);
    }

    public String toString() {
        return "ParamInfo: maxChannel=" + this.maxChannel + ", flags=0x" + Long.toHexString(this.flags) + ", maxMsgLen=" + this.maxMsgLen + ", maxSenderWarning=" + this.maxSenderWarning + ", maxReceiverWarning=" + this.maxReceiverWarning + ", minMsgInterval=" + this.minMsgInterval;
    }
}

