/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoData;

public final class ExtraInfoBlock
implements Writable {
    public static final int TYPE_ICONHASH = 1;
    public static final int TYPE_AVAILMSG = 2;
    public static final int TYPE_AIMEXPINFO = 128;
    public static final int TYPE_CERTINFO_HASHA = 1026;
    public static final int TYPE_CERTINFO_HASHB = 1027;
    private final int type;
    private final ExtraInfoData extraData;
    private final int totalSize;

    public static ExtraInfoBlock[] readExtraInfoBlocks(ByteBlock byteBlock) {
        ExtraInfoBlock extraInfoBlock;
        DefensiveTools.checkNull(byteBlock, "block");
        LinkedList<ExtraInfoBlock> linkedList = new LinkedList<ExtraInfoBlock>();
        while ((extraInfoBlock = ExtraInfoBlock.readExtraInfoBlock(byteBlock)) != null) {
            linkedList.add(extraInfoBlock);
            byteBlock = byteBlock.subBlock(extraInfoBlock.getTotalSize());
        }
        return linkedList.toArray(new ExtraInfoBlock[0]);
    }

    public static ExtraInfoBlock readExtraInfoBlock(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ExtraInfoData extraInfoData = ExtraInfoData.readExtraInfoData(byteBlock2);
        int n2 = 2;
        if (extraInfoData != null) {
            n2 += extraInfoData.getTotalSize();
        }
        return new ExtraInfoBlock(n, extraInfoData, n2);
    }

    protected ExtraInfoBlock(int n, ExtraInfoData extraInfoData, int n2) {
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        this.type = n;
        this.extraData = extraInfoData;
        this.totalSize = n2;
    }

    public ExtraInfoBlock(int n, ExtraInfoData extraInfoData) {
        this(n, extraInfoData, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final ExtraInfoData getExtraData() {
        return this.extraData;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 2L + (this.extraData == null ? 0L : this.extraData.getWritableLength());
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        if (this.extraData != null) {
            this.extraData.write(outputStream);
        }
    }

    public String toString() {
        return "ExtraInfoBlock: type=0x" + Long.toHexString(this.type) + ", extraData=<" + this.extraData + ">";
    }
}

