/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

public final class ConnectionQueueMgr {
    private final RateLimitingQueueMgr queueMgr;
    private final RateMonitor monitor;
    private final ClientSnacProcessor snacProcessor;
    private boolean paused = false;
    private final Map queues = new IdentityHashMap();
    private RateListener rateListener = new RateListener(){

        public void detached(RateMonitor rateMonitor, ClientSnacProcessor clientSnacProcessor) {
            rateMonitor.removeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(RateMonitor rateMonitor) {
            ConnectionQueueMgr connectionQueueMgr = ConnectionQueueMgr.this;
            synchronized (connectionQueueMgr) {
                ConnectionQueueMgr.this.clearQueues();
            }
        }

        public void gotRateClasses(RateMonitor rateMonitor) {
            ConnectionQueueMgr.this.updateRateClasses();
        }

        public void rateClassUpdated(RateMonitor rateMonitor, RateClassMonitor rateClassMonitor, RateClassInfo rateClassInfo) {
            RateQueue rateQueue = ConnectionQueueMgr.this.getRateQueue(rateClassMonitor);
            ConnectionQueueMgr.this.queueMgr.getRunner().update(rateQueue);
        }

        public void rateClassLimited(RateMonitor rateMonitor, RateClassMonitor rateClassMonitor, boolean bl) {
            ConnectionQueueMgr.this.queueMgr.getRunner().update(ConnectionQueueMgr.this.getRateQueue(rateClassMonitor));
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    ConnectionQueueMgr(RateLimitingQueueMgr rateLimitingQueueMgr, ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(rateLimitingQueueMgr, "queueMgr");
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        this.queueMgr = rateLimitingQueueMgr;
        this.monitor = new RateMonitor(clientSnacProcessor);
        this.snacProcessor = clientSnacProcessor;
        this.monitor.addListener(this.rateListener);
    }

    public RateLimitingQueueMgr getParentQueueMgr() {
        return this.queueMgr;
    }

    public RateMonitor getRateMonitor() {
        return this.monitor;
    }

    public ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    private synchronized RateQueue getRateQueue(RateClassMonitor rateClassMonitor) {
        DefensiveTools.checkNull(rateClassMonitor, "classMonitor");
        return (RateQueue)this.queues.get(rateClassMonitor);
    }

    public synchronized RateQueue getRateQueue(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        RateClassMonitor rateClassMonitor = this.monitor.getMonitor(cmdType);
        if (rateClassMonitor == null) {
            return null;
        }
        return this.getRateQueue(rateClassMonitor);
    }

    void queueSnac(SnacRequest snacRequest) {
        DefensiveTools.checkNull(snacRequest, "request");
        CmdType cmdType = CmdType.ofCmd(snacRequest.getCommand());
        RateQueue rateQueue = this.getRateQueue(cmdType);
        if (rateQueue == null) {
            this.queueMgr.sendSnac(this.snacProcessor, snacRequest);
        } else {
            rateQueue.enqueue(snacRequest);
            this.queueMgr.getRunner().update(rateQueue);
        }
    }

    synchronized void clearQueue() {
        Iterator iterator = this.queues.values().iterator();
        while (iterator.hasNext()) {
            RateQueue rateQueue = (RateQueue)iterator.next();
            rateQueue.clear();
        }
        this.paused = false;
    }

    synchronized void pause() {
        if (!$assertionsDisabled && this.paused) {
            throw new AssertionError();
        }
        this.paused = true;
    }

    synchronized void unpause() {
        if (!$assertionsDisabled && !this.paused) {
            throw new AssertionError();
        }
        this.paused = false;
        this.queueMgr.getRunner().update(this);
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    private synchronized void updateRateClasses() {
        Object object;
        int n;
        RateClassMonitor[] rateClassMonitorArray = this.monitor.getMonitors();
        RateQueue[] rateQueueArray = this.clearQueues();
        LinkedList linkedList = new LinkedList();
        for (n = 0; n < rateQueueArray.length; ++n) {
            object = rateQueueArray[n];
            ((RateQueue)object).dequeueAll(linkedList);
        }
        for (n = 0; n < rateClassMonitorArray.length; ++n) {
            object = new RateQueue(this, rateClassMonitorArray[n]);
            this.queues.put(rateClassMonitorArray[n], object);
        }
        RateQueue[] rateQueueArray2 = linkedList.iterator();
        while (rateQueueArray2.hasNext()) {
            object = (SnacRequest)rateQueueArray2.next();
            this.queueSnac((SnacRequest)object);
        }
        rateQueueArray2 = this.queues.values().toArray(new RateQueue[0]);
        this.queueMgr.getRunner().addQueues(rateQueueArray2);
        this.queueMgr.getRunner().update(this);
    }

    private synchronized RateQueue[] clearQueues() {
        RateQueue[] rateQueueArray = this.queues.values().toArray(new RateQueue[0]);
        this.queueMgr.getRunner().removeQueues(rateQueueArray);
        this.queues.clear();
        return rateQueueArray;
    }

    synchronized void detach() {
        this.clearQueue();
        this.clearQueues();
        this.monitor.detach();
    }

    static {
        $assertionsDisabled = !ConnectionQueueMgr.class.desiredAssertionStatus();
    }
}

