/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.util.ArrayList;
import java.util.Hashtable;
import org.hn.sleek.jmml.Capabilities;
import org.hn.sleek.jmml.ContactList;
import org.hn.sleek.jmml.ContactStatus;
import org.hn.sleek.jmml.MSNException;

public class Contact {
    public static final int HOME_PHONE_NUMBER = 1;
    public static final int WORK_PHONE_NUMBER = 2;
    public static final int MOBILE_PHONE_NUMBER = 3;
    public static final int MOBILE_ENABLED = 4;
    public static final int CONTACTLIST_TYPE = 5;
    public static final int STATUS = 6;
    public static final int FRIENDLY_NAME = 7;
    public static final int CAPABILITIES = 8;
    String strUserName;
    String strFriendlyName;
    String strRealName;
    ContactStatus status;
    Capabilities capabilities;
    ArrayList aGroups;
    Hashtable hListType;
    String strHomePhoneNumber;
    String strWorkPhoneNumber;
    String strMobilePhoneNumber;
    boolean bMobileEnabled;

    public Contact(String strUserName, int nListType) {
        this.strUserName = strUserName;
        this.strFriendlyName = "";
        this.strRealName = "";
        this.status = new ContactStatus("UNKNOWN");
        this.strHomePhoneNumber = "";
        this.strWorkPhoneNumber = "";
        this.strMobilePhoneNumber = "";
        this.bMobileEnabled = false;
        this.aGroups = new ArrayList();
        this.hListType = new Hashtable();
        this.capabilities = new Capabilities(0L);
        this.addToListType(nListType);
    }

    void setFriendlyName(String strFriendlyName) {
        this.strFriendlyName = strFriendlyName;
    }

    public String getFriendlyName() {
        return this.strFriendlyName;
    }

    void setRealName(String strRealName) {
        this.strRealName = strRealName;
    }

    public String getRealName() {
        return this.strRealName;
    }

    void setUserName(String strUserName) {
        this.strUserName = strUserName;
    }

    public String getUserName() {
        return this.strUserName;
    }

    void setStatus(String nStatus) {
        this.status = new ContactStatus(nStatus);
    }

    public ContactStatus getStatus() {
        return this.status;
    }

    public String getPhoneNumber(int which) {
        switch (which) {
            case 1: {
                return this.strHomePhoneNumber;
            }
            case 2: {
                return this.strWorkPhoneNumber;
            }
            case 3: {
                return this.strMobilePhoneNumber;
            }
        }
        return "";
    }

    void setPhoneNumber(int which, String phoneNumber) {
        switch (which) {
            case 1: {
                this.strHomePhoneNumber = phoneNumber;
                break;
            }
            case 2: {
                this.strWorkPhoneNumber = phoneNumber;
                break;
            }
            case 3: {
                this.strMobilePhoneNumber = phoneNumber;
            }
        }
    }

    void setMobileEnabled(boolean bMobileEnabled) {
        this.bMobileEnabled = bMobileEnabled;
    }

    public boolean getMobileEnabled() {
        return this.bMobileEnabled;
    }

    void setGroups(ArrayList aGroups) {
        if (aGroups != null) {
            this.aGroups = aGroups;
        } else {
            this.aGroups.clear();
        }
    }

    public ArrayList getGroups() {
        return (ArrayList)this.aGroups.clone();
    }

    void addToGroup(int nGroupId) throws MSNException {
        for (int nCount = 0; nCount < this.aGroups.size(); ++nCount) {
            if ((Integer)this.aGroups.get(nCount) != nGroupId) continue;
            throw new MSNException(7);
        }
        this.aGroups.add(new Integer(nGroupId));
    }

    void removeFromGroup(int nGroupId) throws MSNException {
        for (int nCount = 0; nCount < this.aGroups.size(); ++nCount) {
            if ((Integer)this.aGroups.get(nCount) != nGroupId) continue;
            this.aGroups.remove(nCount);
            return;
        }
        throw new MSNException(9);
    }

    boolean containGroup(int nGroupId) {
        for (int nCount = 0; nCount < this.aGroups.size(); ++nCount) {
            if ((Integer)this.aGroups.get(nCount) != nGroupId) continue;
            return true;
        }
        return false;
    }

    void setListType(Hashtable hListType) {
        this.hListType = hListType;
    }

    Hashtable getListType() {
        return (Hashtable)this.hListType.clone();
    }

    void addToListType(int nListType) {
        if (nListType != -1) {
            Integer iListType = ContactList.parseListTypeToInteger(ContactList.parseListType(nListType));
            this.hListType.put(iListType, iListType);
        }
    }

    void removeFromListType(int nListType) {
        if (nListType != -1) {
            Integer iKey = ContactList.parseListTypeToInteger(ContactList.parseListType(nListType));
            Integer iObject = (Integer)this.hListType.get(iKey);
            this.hListType.remove(iObject);
        }
    }

    boolean isInListType(int nListType) {
        if (nListType != -1) {
            Integer iKey = ContactList.parseListTypeToInteger(ContactList.parseListType(nListType));
            return this.hListType.containsKey(iKey);
        }
        return false;
    }

    void clearListType() {
        this.hListType.clear();
    }

    boolean containsInListType() {
        return this.hListType.size() > 0;
    }

    public boolean isAllowed() {
        return this.hListType.get(new Integer(0)) != null;
    }

    public boolean isBlocked() {
        return this.hListType.get(new Integer(1)) != null;
    }

    public boolean isContact() {
        return this.hListType.get(new Integer(3)) != null;
    }

    public boolean isReverse() {
        return this.hListType.get(new Integer(2)) != null;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public static String propertyToString(int property) {
        switch (property) {
            case 6: {
                return "status";
            }
            case 7: {
                return "friendly name";
            }
            case 1: {
                return "home phone number";
            }
            case 2: {
                return "work phone number";
            }
            case 3: {
                return "mobile phone number";
            }
            case 4: {
                return "mobile enabled";
            }
        }
        return "unknown";
    }

    public String getDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append("UserName: " + this.getUserName());
        sb.append("\nFriendlyName: " + this.getFriendlyName());
        sb.append("\nStatus: " + this.getStatus());
        return sb.toString();
    }

    public String toString() {
        if (this.strFriendlyName != null) {
            return this.strFriendlyName;
        }
        return this.strUserName;
    }
}

