/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import ymsg.network.DebugInputStream;
import ymsg.network.YMSG9Packet;

public class YMSG9InputStream
extends BufferedInputStream {
    DebugInputStream dbis = null;

    public YMSG9InputStream(InputStream inputStream) {
        super(inputStream);
        if (inputStream instanceof DebugInputStream) {
            this.dbis = (DebugInputStream)inputStream;
        }
    }

    public YMSG9Packet readPacket() throws IOException {
        int n;
        byte[] byArray;
        YMSG9Packet yMSG9Packet = new YMSG9Packet();
        if (this.dbis != null) {
            this.dbis.debugReset();
        }
        if (this.readBuffer(byArray = new byte[20]) <= 0) {
            return null;
        }
        yMSG9Packet.magic = "" + (char)byArray[0] + (char)byArray[1] + (char)byArray[2] + (char)byArray[3];
        yMSG9Packet.version = this.u2i(byArray[5]);
        yMSG9Packet.length = (this.u2i(byArray[8]) << 8) + this.u2i(byArray[9]);
        yMSG9Packet.service = (this.u2i(byArray[10]) << 8) + this.u2i(byArray[11]);
        yMSG9Packet.status = (this.u2i(byArray[12]) << 24) + (this.u2i(byArray[13]) << 16) + (this.u2i(byArray[14]) << 8) + this.u2i(byArray[15]);
        yMSG9Packet.sessionId = (this.u2i(byArray[16]) << 24) + (this.u2i(byArray[17]) << 16) + (this.u2i(byArray[18]) << 8) + this.u2i(byArray[19]);
        if (!yMSG9Packet.magic.equals("YMSG")) {
            throw new IOException("Bad YMSG9 header");
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = new byte[yMSG9Packet.length];
        if (this.readBuffer(byArray2) < 0) {
            return null;
        }
        if (this.dbis != null) {
            this.dbis.debugDump();
        }
        int n2 = 0;
        for (n = 0; n < byArray2.length - 1; ++n) {
            if (this.u2i(byArray2[n]) != 192 || this.u2i(byArray2[n + 1]) != 128) continue;
            String string = new String(byArray2, n2, n - n2, "UTF-8");
            vector.addElement(string);
            if (this.dbis != null) {
                System.out.println(">>" + string);
            }
            n2 = ++n + 1;
        }
        yMSG9Packet.body = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            yMSG9Packet.body[n] = (String)vector.elementAt(n);
        }
        return yMSG9Packet;
    }

    private int u2i(byte by) {
        return by & 0xFF;
    }

    private int readBuffer(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length; n += n2) {
            n2 = super.read(byArray, n, byArray.length - n);
            if (n2 >= 0) continue;
            return (n + 1) * -1;
        }
        return n;
    }
}

