/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetExtraInfoCmd
extends ConnCommand {
    public static final int ICQSTATUS_NONE = -1;
    private static final int TYPE_ICQSTATUS = 6;
    private static final int TYPE_DATA = 29;
    private final long icqstatus;
    private final List<ExtraInfoBlock> blocks;

    protected SetExtraInfoCmd(SnacPacket packet) {
        super(30);
        ByteBlock data = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(data);
        Tlv statusTlv = chain.getLastTlv(6);
        this.icqstatus = statusTlv != null ? statusTlv.getDataAsUInt() : -1L;
        Tlv dataTlv = chain.getLastTlv(29);
        if (dataTlv != null) {
            ByteBlock blockData = dataTlv.getData();
            this.blocks = ExtraInfoBlock.readExtraInfoBlocks(blockData);
        } else {
            this.blocks = null;
        }
    }

    public SetExtraInfoCmd(long icqstatus) {
        this(icqstatus, null);
    }

    public SetExtraInfoCmd(ExtraInfoBlock ... blocks) {
        this(Arrays.asList(blocks));
    }

    public SetExtraInfoCmd(List<ExtraInfoBlock> blocks) {
        this(-1L, blocks);
    }

    public SetExtraInfoCmd(long icqstatus, List<ExtraInfoBlock> blocks) {
        super(30);
        DefensiveTools.checkRange((long)icqstatus, (String)"icqstatus", (long)-1L);
        this.icqstatus = icqstatus;
        this.blocks = DefensiveTools.getSafeListCopy(blocks, (String)"blocks");
    }

    public final long getIcqStatus() {
        return this.icqstatus;
    }

    public final List<ExtraInfoBlock> getInfoBlocks() {
        return this.blocks;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.icqstatus != -1L) {
            Tlv.getUIntInstance(6, this.icqstatus).write(out);
        }
        if (this.blocks != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (ExtraInfoBlock block : this.blocks) {
                block.write(bout);
            }
            new Tlv(29, (Writable)ByteBlock.wrap((byte[])bout.toByteArray())).write(out);
        }
    }

    public String toString() {
        return "SetExtraInfoCmd: blocks=" + (this.blocks == null ? null : this.blocks) + (this.icqstatus != -1L ? ", icqstatus=" + this.icqstatus : "");
    }
}

