/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;

public final class CmdType {
    public static final int ALL = -1;
    public static final CmdType CMDTYPE_ALL = new CmdType(-1, -1);
    private final int family;
    private final int command;

    public static CmdType ofCmd(SnacCommand command) {
        DefensiveTools.checkNull((Object)command, (String)"command");
        return new CmdType(command.getFamily(), command.getCommand());
    }

    public CmdType(int family) {
        this(family, -1);
    }

    public CmdType(int family, int command) throws IllegalArgumentException {
        if (family == -1 && command != -1) {
            throw new IllegalArgumentException("if family is CmdType.ALL (-1),, command type must be as well (instead it is " + command + ")");
        }
        if (family != -1 && family < 0) {
            throw new IllegalArgumentException("family must be CmdType.ALL or a positive number (was " + family + ")");
        }
        if (command != -1 && command < 0) {
            throw new IllegalArgumentException("command type must be CmdType.ALL or a positive number");
        }
        this.family = family;
        this.command = command;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CmdType)) {
            return false;
        }
        CmdType other = (CmdType)o;
        return this.family == other.family && this.command == other.command;
    }

    public int hashCode() {
        return this.family << 16 ^ this.command;
    }

    public String toString() {
        if (this.family == -1) {
            return "CmdType: all commands";
        }
        if (this.command == -1) {
            return "CmdType: all commands in family 0x" + Integer.toHexString(this.family);
        }
        return "CmdType: 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command);
    }
}

