/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.invitation;

import java.io.File;
import net.sf.jml.MsnConnectionType;
import net.sf.jml.MsnContact;
import net.sf.jml.message.invitation.MsnCancelMessage;
import net.sf.jml.message.invitation.MsnInviteMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;

public class MsnftpInviteMessage
extends MsnInviteMessage {
    private static final String KEY_APP_FILE = "Application-File";
    private static final String KEY_APP_FILESIZE = "Application-FileSize";
    private static final String KEY_CONNECTIVITY = "Connectivity";
    private static final String NAME = "File Transfer";
    private File file;

    public MsnftpInviteMessage() {
        this.setApplicationName(NAME);
        this.setApplicationGUID("{5D3E02AB-6190-11d3-BBBB-00C04F795683}");
        this.setApplicationFileSize(0L);
    }

    public String getApplicationFile() {
        return this.properties.getProperty(KEY_APP_FILE);
    }

    public long getApplicationFileSize() {
        return NumberUtils.stringToLong(this.properties.getProperty(KEY_APP_FILESIZE));
    }

    public void setApplicationFile(String string) {
        this.properties.setProperty(KEY_APP_FILE, string);
    }

    public void setApplicationFileSize(long l) {
        this.properties.setProperty(KEY_APP_FILESIZE, String.valueOf(l));
    }

    public void setConnectionType(MsnConnectionType msnConnectionType) {
        if (msnConnectionType == MsnConnectionType.NAT) {
            this.properties.setProperty(KEY_CONNECTIVITY, "N");
        } else if (msnConnectionType == MsnConnectionType.UPNP) {
            this.properties.setProperty(KEY_CONNECTIVITY, "U");
        } else {
            this.properties.removeProperty(KEY_CONNECTIVITY);
        }
    }

    public MsnConnectionType getConnectionType() {
        String string = this.properties.getProperty(KEY_CONNECTIVITY);
        if ("N".equals(string)) {
            return MsnConnectionType.NAT;
        }
        if ("U".equals(string)) {
            return MsnConnectionType.UPNP;
        }
        return MsnConnectionType.DIRECT;
    }

    public void setFile(File file) throws IllegalArgumentException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("file " + file + " not found");
        }
        this.file = file;
        this.setApplicationFile(file.getName());
        this.setApplicationFileSize(file.length());
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        MsnCancelMessage msnCancelMessage = new MsnCancelMessage(this);
        msnCancelMessage.setCancelCode("REJECT");
        msnSession.getSwitchboard().sendMessage(msnCancelMessage);
    }
}

