/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import net.sf.jml.MsnConnectionType;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnConnectionImpl;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.Charset;

public final class MsnSystemMessage
extends MsnMimeMessage {
    private String content;

    MsnSystemMessage() {
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
        super.parseBuffer(byteBuffer);
        this.content = Charset.decode(byteBuffer);
    }

    public String getContent() {
        return this.content;
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        String string = this.getContentType();
        if (string != null && string.startsWith("text/x-msmsgsprofile")) {
            MsnConnectionImpl msnConnectionImpl = (MsnConnectionImpl)msnSession.getMessenger().getConnection();
            msnConnectionImpl.setExternalIP(this.headers.getProperty("ClientIP"));
            msnConnectionImpl.setExternalPort(this.headers.getIntProperty("ClientPort", -1));
            if (msnConnectionImpl.getInternalIP().equals(msnConnectionImpl.getExternalIP()) && msnConnectionImpl.getInternalPort() == msnConnectionImpl.getExternalPort()) {
                msnConnectionImpl.setConnectionType(MsnConnectionType.DIRECT);
            } else {
                msnConnectionImpl.setConnectionType(MsnConnectionType.NAT);
            }
        }
        ((AbstractMessenger)msnSession.getMessenger()).fireSystemMessageReceived(this);
    }
}

