/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util;

import net.sf.cindy.util.ElapsedTime;

public final class Speed {
    private final ElapsedTime time = new ElapsedTime();
    private final int refreshRate;
    private final long[] values;
    private final double[] rate;
    private long lastUpdateTimeFactor;
    private long currentValue;
    private long totalValue;

    private Speed(int n, int n2) {
        this.refreshRate = n;
        this.values = new long[n2];
        this.rate = new double[n2];
        double d = 2.0 / (double)(n2 + 1);
        for (int i = 0; i < this.rate.length; ++i) {
            this.rate[i] = (double)(this.rate.length - i) * d;
        }
    }

    public static Speed getInstance(int n, int n2) {
        if (n2 < n) {
            return null;
        }
        return new Speed(n, n2 / n);
    }

    public static Speed getInstance() {
        return Speed.getInstance(1000, 5000);
    }

    public synchronized void reset() {
        this.lastUpdateTimeFactor = 0L;
        this.currentValue = 0L;
        this.totalValue = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = 0L;
        }
        this.time.reset();
    }

    private int getIndex(long l) {
        return Math.abs((int)(l % (long)this.values.length));
    }

    private synchronized void update(long l) {
        if (this.lastUpdateTimeFactor == l) {
            return;
        }
        this.values[this.getIndex((long)this.lastUpdateTimeFactor)] = this.currentValue;
        this.currentValue = 0L;
        if (this.lastUpdateTimeFactor < l - (long)this.values.length) {
            this.lastUpdateTimeFactor = l - (long)this.values.length - 1L;
        }
        for (long i = this.lastUpdateTimeFactor + 1L; i < l; ++i) {
            this.values[this.getIndex((long)i)] = 0L;
        }
        this.lastUpdateTimeFactor = l;
    }

    public void addValue(long l) {
        long l2 = this.time.getElapsedTime() / (long)this.refreshRate;
        this.update(l2);
        this.currentValue += l;
        this.totalValue += l;
    }

    public long getTotalValue() {
        return this.totalValue;
    }

    public long getElapsedTime() {
        return this.time.getElapsedTime();
    }

    public double getAvgSpeed() {
        long l = this.time.getElapsedTime();
        if (this.totalValue == 0L && l == 0L) {
            return 0.0;
        }
        return (double)this.totalValue * 1000.0 / (double)l;
    }

    public double getSpeed() {
        long l = this.time.getElapsedTime() / (long)this.refreshRate;
        this.update(l);
        double d = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            int n = this.getIndex(l - (long)i - 1L);
            d += (double)this.values[n] * this.rate[i];
        }
        return d * 1000.0 / (double)this.refreshRate / (double)this.values.length;
    }
}

