/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.Vector;

class YMSG9Packet {
    String magic;
    int version;
    int length;
    int service;
    long status;
    long sessionId;
    String[] body;

    YMSG9Packet() {
    }

    private int getNthLocation(String k, int n) {
        for (int i = 0; i < this.body.length; i += 2) {
            if (this.body[i].equals(k)) {
                --n;
            }
            if (n >= 0) continue;
            return i;
        }
        return -1;
    }

    String getNthValue(String k, int n) {
        int l = this.getNthLocation(k, n);
        if (l < 0) {
            return null;
        }
        return this.body[l + 1];
    }

    String getValue(String k) {
        return this.getNthValue(k, 0);
    }

    String[] getValues(String k) {
        int cnt = 0;
        int j = 0;
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(k)) continue;
            ++cnt;
        }
        String[] sa = new String[cnt];
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(k)) continue;
            sa[j++] = this.body[i + 1];
        }
        return sa;
    }

    String getValueFromNthSet(String set, String k, int n) {
        int i = this.getNthLocation(set, n);
        if (i < 0) {
            return null;
        }
        i += 2;
        while (i < this.body.length) {
            if (this.body[i].equals(k)) {
                return this.body[i + 1];
            }
            if (this.body[i].equals(set)) {
                return null;
            }
            i += 2;
        }
        return null;
    }

    boolean exists(String k) {
        return this.getValue(k) != null;
    }

    void append(YMSG9Packet pkt) {
        String[] arr = new String[this.body.length + pkt.body.length];
        System.arraycopy(this.body, 0, arr, 0, this.body.length);
        System.arraycopy(pkt.body, 0, arr, this.body.length, pkt.body.length);
        this.body = arr;
    }

    void merge(YMSG9Packet pkt, String[] concatFields) {
        Vector<String> appendBuffer = new Vector<String>();
        for (int i = 0; i < pkt.body.length; i += 2) {
            String k = pkt.body[i];
            String v = pkt.body[i + 1];
            boolean b = false;
            for (int j = 0; j < concatFields.length; ++j) {
                if (!concatFields[j].equals(k)) continue;
                b = true;
                break;
            }
            if (b) {
                int idx = this.getNthLocation(k, 0);
                if (idx < 0) {
                    appendBuffer.addElement(k);
                    appendBuffer.addElement(pkt.body[i + 1]);
                    continue;
                }
                this.body[idx + 1] = this.body[idx + 1] + v;
                continue;
            }
            appendBuffer.addElement(k);
            appendBuffer.addElement(pkt.body[i + 1]);
        }
        if (appendBuffer.size() > 0) {
            String[] arr = new String[this.body.length + appendBuffer.size()];
            System.arraycopy(this.body, 0, arr, 0, this.body.length);
            for (int i = 0; i < appendBuffer.size(); ++i) {
                arr[this.body.length + i] = (String)appendBuffer.elementAt(i);
            }
            this.body = arr;
        }
    }

    public String toString() {
        String s = "Magic:" + this.magic + " Version:" + this.version + " Length:" + this.length + " Service:" + this.service + " Status:" + this.status + " SessionId:0x" + Long.toHexString(this.sessionId) + "\n ";
        for (int i = 0; i < this.body.length; ++i) {
            s = s + " [" + this.body[i] + "]";
        }
        return s;
    }
}

