/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.concurrent.ReaderPreferenceReadWriteLock;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.proxool.CompositeConnectionListener;
import org.logicalcobwebs.proxool.CompositeStateListener;
import org.logicalcobwebs.proxool.ConnectionInfo;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ConnectionResetter;
import org.logicalcobwebs.proxool.ConnectionValidatorIF;
import org.logicalcobwebs.proxool.DefaultConnectionValidator;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.Prototyper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.ShutdownHook;
import org.logicalcobwebs.proxool.StateListenerIF;
import org.logicalcobwebs.proxool.admin.Admin;
import org.logicalcobwebs.proxool.util.FastArrayList;

class ConnectionPool
implements ConnectionPoolStatisticsIF {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$ConnectionPool == null ? (class$org$logicalcobwebs$proxool$ConnectionPool = ConnectionPool.class$("org.logicalcobwebs.proxool.ConnectionPool")) : class$org$logicalcobwebs$proxool$ConnectionPool));
    private Log log;
    private ReaderPreferenceReadWriteLock connectionStatusReadWriteLock = new ReaderPreferenceReadWriteLock();
    private WriterPreferenceReadWriteLock primaryReadWriteLock = new WriterPreferenceReadWriteLock();
    private static final String[] STATUS_DESCRIPTIONS = new String[]{"NULL", "AVAILABLE", "ACTIVE", "OFFLINE"};
    private static final String MSG_MAX_CONNECTION_COUNT = "Couldn't get connection because we are at maximum connection count and there are none available";
    private List proxyConnections;
    private int nextAvailableConnection = 0;
    private long connectionsServedCount = 0L;
    private long connectionsRefusedCount = 0L;
    private int[] connectionCountByState = new int[4];
    private ConnectionPoolDefinition definition;
    private CompositeConnectionListener compositeConnectionListener = new CompositeConnectionListener();
    private CompositeStateListener compositeStateListener = new CompositeStateListener();
    private long timeOfLastRefusal = 0L;
    private int upState;
    private static boolean loggedLegend;
    private Admin admin;
    private boolean locked = false;
    private Date dateStarted = new Date();
    private boolean connectionPoolUp = false;
    private Thread shutdownThread;
    private Prototyper prototyper;
    private ConnectionResetter connectionResetter;
    private ConnectionValidatorIF connectionValidator;
    protected static final boolean FORCE_EXPIRY = true;
    protected static final boolean REQUEST_EXPIRY = false;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ConnectionPool;

    protected ConnectionPool(ConnectionPoolDefinition definition) throws ProxoolException {
        FastArrayList fal = new FastArrayList();
        fal.setFast(true);
        this.proxyConnections = fal;
        this.log = LogFactory.getLog((String)("org.logicalcobwebs.proxool." + definition.getAlias()));
        this.connectionResetter = new ConnectionResetter(this.log, definition.getDriver());
        this.setDefinition(definition);
        this.connectionValidator = new DefaultConnectionValidator();
        if (definition.getStatistics() != null) {
            try {
                this.admin = new Admin(definition);
            }
            catch (ProxoolException e) {
                this.log.error((Object)"Failed to initialise statistics", (Throwable)e);
            }
        }
        ShutdownHook.init();
    }

    protected void start() throws ProxoolException {
        this.connectionPoolUp = true;
        this.prototyper = new Prototyper(this);
        HouseKeeperController.register(this);
    }

    protected Connection getConnection() throws SQLException {
        ProxyConnection proxyConnection;
        block27: {
            String requester = Thread.currentThread().getName();
            try {
                this.prototyper.quickRefuse();
            }
            catch (SQLException e) {
                ++this.connectionsRefusedCount;
                if (this.admin != null) {
                    this.admin.connectionRefused();
                }
                this.log.info((Object)(this.displayStatistics() + " - " + MSG_MAX_CONNECTION_COUNT));
                this.timeOfLastRefusal = System.currentTimeMillis();
                this.setUpState(2);
                throw e;
            }
            this.prototyper.checkSimultaneousBuildThrottle();
            proxyConnection = null;
            try {
                for (int connectionsTried = 0; connectionsTried < this.proxyConnections.size(); ++connectionsTried) {
                    try {
                        proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.nextAvailableConnection = 0;
                        proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.nextAvailableConnection = 0;
                        proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
                    }
                    if (proxyConnection != null && proxyConnection.setStatus(1, 2)) {
                        if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnection)) {
                            proxyConnection = null;
                        }
                        if (proxyConnection != null) {
                            ++this.nextAvailableConnection;
                            break;
                        }
                    } else {
                        proxyConnection = null;
                    }
                    ++this.nextAvailableConnection;
                }
                if (proxyConnection != null) break block27;
                try {
                    proxyConnection = this.prototyper.buildConnection(2, "on demand");
                    if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnection)) {
                        throw new SQLException("Created a new connection but it failed its test");
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (ProxoolException e) {
                    this.log.debug((Object)"Couldn't get connection", (Throwable)e);
                    throw new SQLException(e.toString());
                }
                catch (Throwable e) {
                    this.log.error((Object)"Couldn't get connection", e);
                    throw new SQLException(e.toString());
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Throwable t) {
                this.log.error((Object)"Problem getting connection", t);
                throw new SQLException(t.toString());
            }
            finally {
                if (proxyConnection != null) {
                    ++this.connectionsServedCount;
                    proxyConnection.setRequester(requester);
                } else {
                    ++this.connectionsRefusedCount;
                    if (this.admin != null) {
                        this.admin.connectionRefused();
                    }
                    this.timeOfLastRefusal = System.currentTimeMillis();
                    this.setUpState(2);
                }
            }
        }
        if (proxyConnection == null) {
            throw new SQLException("Unknown reason for not getting connection. Sorry.");
        }
        if (this.log.isDebugEnabled() && this.getDefinition().isVerbose()) {
            this.log.debug((Object)(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " served"));
        }
        proxyConnection.open();
        return ProxyFactory.getWrappedConnection(proxyConnection);
    }

    private boolean testConnection(ProxyConnectionIF proxyConnection) {
        if (this.connectionValidator == null) {
            return true;
        }
        boolean success = this.connectionValidator.validate(this.getDefinition(), proxyConnection.getConnection());
        if (success) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " tested: OK"));
            }
        } else {
            proxyConnection.setStatus(0);
            this.removeProxyConnection(proxyConnection, 3, "it didn't pass the validation", false, true);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addProxyConnection(ProxyConnectionIF proxyConnection) {
        boolean added = false;
        try {
            this.acquireConnectionStatusWriteLock();
            if (proxyConnection.getDefinition() == this.getDefinition()) {
                this.proxyConnections.add(proxyConnection);
                int n = proxyConnection.getStatus();
                this.connectionCountByState[n] = this.connectionCountByState[n] + 1;
                added = true;
            }
        }
        finally {
            this.releaseConnectionStatusWriteLock();
        }
        return added;
    }

    protected static String getStatusDescription(int status) {
        try {
            return STATUS_DESCRIPTIONS[status];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown status: " + status;
        }
    }

    protected void putConnection(ProxyConnectionIF proxyConnection) {
        if (this.admin != null) {
            long start;
            long now = System.currentTimeMillis();
            if (now - (start = proxyConnection.getTimeLastStartActive()) < 0L) {
                this.log.warn((Object)("Future start time detected. #" + proxyConnection.getId() + " start = " + new Date(start) + " (" + (now - start) + " milliseconds)"));
            } else if (now - start > 1000000L) {
                this.log.warn((Object)("Suspiciously long active time. #" + proxyConnection.getId() + " start = " + new Date(start)));
            }
            this.admin.connectionReturned(now - start);
        }
        if (proxyConnection.isMarkedForExpiry()) {
            if (proxyConnection.setStatus(2, 0)) {
                this.expireProxyConnection(proxyConnection, proxyConnection.getReasonCode(), proxyConnection.getReasonForMark(), false);
            }
        } else {
            if (this.getDefinition().isTestAfterUse()) {
                this.testConnection(proxyConnection);
            }
            if (!proxyConnection.setStatus(2, 1)) {
                if (proxyConnection.getStatus() == 1) {
                    this.log.warn((Object)("Unable to close connection " + proxyConnection.getId() + " - I suspect that it has been closed already. Closing it more" + " than once is unwise and should be avoided."));
                } else {
                    this.log.warn((Object)("Unable to set status of connection " + proxyConnection.getId() + " from " + ConnectionPool.getStatusDescription(2) + " to " + ConnectionPool.getStatusDescription(1) + " because it's state was " + ConnectionPool.getStatusDescription(proxyConnection.getStatus())));
                }
            }
        }
        if (this.log.isDebugEnabled() && this.getDefinition().isVerbose()) {
            this.log.debug((Object)(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " returned (now " + ConnectionPool.getStatusDescription(proxyConnection.getStatus()) + ")"));
        }
    }

    protected void throwConnection(ProxyConnectionIF proxyConnection, int reasonCode, String reason) {
        this.expireConnectionAsSoonAsPossible(proxyConnection, reasonCode, reason, true);
    }

    private ProxyConnectionIF getProxyConnection(int i) {
        return (ProxyConnectionIF)this.proxyConnections.get(i);
    }

    protected ProxyConnectionIF[] getProxyConnections() {
        return this.proxyConnections.toArray(new ProxyConnectionIF[this.proxyConnections.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxyConnection(ProxyConnectionIF proxyConnection, int reasonCode, String reason, boolean forceExpiry, boolean triggerSweep) {
        if (forceExpiry || proxyConnection.isNull()) {
            proxyConnection.setStatus(0);
            try {
                this.onDeath(proxyConnection.getConnection(), reasonCode);
            }
            catch (SQLException e) {
                this.log.error((Object)"Problem during onDeath (ignored)", (Throwable)e);
            }
            try {
                proxyConnection.reallyClose();
            }
            catch (SQLException e) {
                this.log.error((Object)e);
            }
            try {
                if (this.isConnectionPoolUp()) {
                    this.acquireConnectionStatusWriteLock();
                }
                this.proxyConnections.remove(proxyConnection);
            }
            finally {
                if (this.isConnectionPoolUp()) {
                    this.releaseConnectionStatusWriteLock();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " removed because " + reason + "."));
            }
            if (triggerSweep) {
                PrototyperController.triggerSweep(this.getDefinition().getAlias());
            }
        } else {
            this.log.error((Object)(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " was not removed because isNull() was false."));
        }
    }

    protected void expireProxyConnection(ProxyConnectionIF proxyConnection, int reasonCode, String reason, boolean forceExpiry) {
        this.removeProxyConnection(proxyConnection, reasonCode, reason, forceExpiry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(int delay, String finalizerName) throws Throwable {
        block33: {
            String alias = this.getDefinition().getAlias();
            try {
                this.acquirePrimaryWriteLock();
                if (this.connectionPoolUp) {
                    this.connectionPoolUp = false;
                    long startFinalize = System.currentTimeMillis();
                    this.shutdownThread = Thread.currentThread();
                    if (delay > 0) {
                        this.log.info((Object)("Shutting down '" + alias + "' pool started at " + this.dateStarted + " - waiting for " + delay + " milliseconds for everything to stop.  [ " + finalizerName + "]"));
                    } else {
                        this.log.info((Object)("Shutting down '" + alias + "' pool immediately [" + finalizerName + "]"));
                    }
                    boolean connectionClosedManually = false;
                    try {
                        try {
                            HouseKeeperController.cancel(alias);
                        }
                        catch (ProxoolException e) {
                            this.log.error((Object)"Shutdown couldn't cancel house keeper", (Throwable)e);
                        }
                        if (this.admin != null) {
                            this.admin.cancelAll();
                        }
                        if (this.connectionCountByState[2] != 0) {
                            long endWait = startFinalize + (long)delay;
                            LOG.info((Object)("Waiting until " + new Date(endWait) + " for all connections to become inactive (active count is " + this.connectionCountByState[2] + ")."));
                            while (true) {
                                int activeCount;
                                long timeout;
                                if ((timeout = endWait - System.currentTimeMillis()) > 0L) {
                                    Thread thread = Thread.currentThread();
                                    synchronized (thread) {
                                        try {
                                            Thread.currentThread().wait(timeout);
                                        }
                                        catch (InterruptedException e) {
                                            this.log.debug((Object)"Interrupted whilst sleeping.");
                                        }
                                    }
                                }
                                if ((activeCount = this.connectionCountByState[2]) == 0) break;
                                if (System.currentTimeMillis() >= endWait) {
                                    LOG.warn((Object)("Shutdown waited for " + (System.currentTimeMillis() - startFinalize) + " milliseconds for all " + "the connections to become inactive but the active count is still " + activeCount + ". Shutting down anyway."));
                                    break;
                                }
                                LOG.info((Object)("Still waiting for active count to reach zero (currently " + activeCount + ")."));
                                Thread.sleep(100L);
                            }
                        }
                        this.prototyper.cancel();
                        for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
                            long id = this.getProxyConnection(i).getId();
                            try {
                                connectionClosedManually = true;
                                this.removeProxyConnection(this.getProxyConnection(i), 4, "of shutdown", true, false);
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug((Object)("Connection #" + id + " closed"));
                                continue;
                            }
                            catch (Throwable t) {
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug((Object)("Problem closing connection #" + id), t);
                            }
                        }
                        ConnectionPoolManager.getInstance().removeConnectionPool(alias);
                    }
                    catch (Throwable t) {
                        try {
                            this.log.error((Object)"Unknown problem finalizing pool", t);
                            break block33;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ConnectionPoolManager.getInstance().removeConnectionPool(alias);
                            if (this.log.isDebugEnabled()) {
                                this.log.info((Object)("'" + alias + "' pool has been closed down by " + finalizerName + " in " + (System.currentTimeMillis() - startFinalize) + " milliseconds."));
                                if (!connectionClosedManually) {
                                    this.log.debug((Object)"No connections required manual removal.");
                                }
                            }
                            super.finalize();
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.info((Object)("'" + alias + "' pool has been closed down by " + finalizerName + " in " + (System.currentTimeMillis() - startFinalize) + " milliseconds."));
                        if (!connectionClosedManually) {
                            this.log.debug((Object)"No connections required manual removal.");
                        }
                    }
                    super.finalize();
                    break block33;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ignoring duplicate attempt to shutdown '" + alias + "' pool by " + finalizerName));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)(finalizerName + " couldn't shutdown pool"), t);
            }
            finally {
                this.releasePrimaryWriteLock();
            }
        }
    }

    public int getAvailableConnectionCount() {
        return this.connectionCountByState[1];
    }

    public int getActiveConnectionCount() {
        return this.connectionCountByState[2];
    }

    public int getOfflineConnectionCount() {
        return this.connectionCountByState[3];
    }

    protected String displayStatistics() {
        if (!loggedLegend) {
            this.log.info((Object)"Proxool statistics legend: \"s - r  (a/t/o)\" > s=served, r=refused (only shown if non-zero), a=active, t=total, o=offline (being tested)");
            loggedLegend = true;
        }
        StringBuffer statistics = new StringBuffer();
        statistics.append(FormatHelper.formatBigNumber(this.getConnectionsServedCount()));
        if (this.getConnectionsRefusedCount() > 0L) {
            statistics.append(" -");
            statistics.append(FormatHelper.formatBigNumber(this.getConnectionsRefusedCount()));
        }
        statistics.append(" (");
        statistics.append(FormatHelper.formatSmallNumber(this.getActiveConnectionCount()));
        statistics.append("/");
        statistics.append(FormatHelper.formatSmallNumber(this.getAvailableConnectionCount() + this.getActiveConnectionCount()));
        statistics.append("/");
        statistics.append(FormatHelper.formatSmallNumber(this.getOfflineConnectionCount()));
        statistics.append(")");
        return statistics.toString();
    }

    protected void expireAllConnections(int reasonCode, String reason, boolean merciful) {
        HashSet pcs = new HashSet();
        for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
            pcs.add(this.proxyConnections.get(i));
        }
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            ProxyConnectionIF pc = (ProxyConnectionIF)i.next();
            this.expireConnectionAsSoonAsPossible(pc, reasonCode, reason, merciful);
        }
    }

    protected void expireConnectionAsSoonAsPossible(ProxyConnectionIF proxyConnection, int reasonCode, String reason, boolean merciful) {
        if (proxyConnection.setStatus(1, 3)) {
            if (proxyConnection.setStatus(3, 0)) {
                this.expireProxyConnection(proxyConnection, reasonCode, reason, false);
            }
        } else if (merciful) {
            proxyConnection.markForExpiry(reason);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " marked for expiry."));
            }
        } else {
            this.expireProxyConnection(proxyConnection, reasonCode, reason, true);
        }
    }

    protected void registerRemovedConnection(int status) {
        this.prototyper.connectionRemoved();
        int n = status;
        this.connectionCountByState[n] = this.connectionCountByState[n] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeStatus(int oldStatus, int newStatus) {
        int n = oldStatus;
        this.connectionCountByState[n] = this.connectionCountByState[n] - 1;
        int n2 = newStatus;
        this.connectionCountByState[n2] = this.connectionCountByState[n2] + 1;
        if (this.shutdownThread != null && this.connectionCountByState[2] == 0) {
            Thread thread = this.shutdownThread;
            synchronized (thread) {
                this.shutdownThread.notify();
            }
        }
    }

    public long getConnectionsServedCount() {
        return this.connectionsServedCount;
    }

    public long getConnectionsRefusedCount() {
        return this.connectionsRefusedCount;
    }

    protected ConnectionPoolDefinition getDefinition() {
        return this.definition;
    }

    protected synchronized void setDefinition(ConnectionPoolDefinition definition) throws ProxoolException {
        this.definition = definition;
        try {
            Class.forName(definition.getDriver());
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Couldn't load class " + definition.getDriver()), (Throwable)e);
            throw new ProxoolException("Couldn't load class " + definition.getDriver());
        }
        catch (NullPointerException e) {
            this.log.error((Object)"Definition did not contain driver", (Throwable)e);
            throw new ProxoolException("Definition did not contain driver");
        }
    }

    public void setStateListener(StateListenerIF stateListener) {
        this.addStateListener(stateListener);
    }

    public void addStateListener(StateListenerIF stateListener) {
        this.compositeStateListener.addListener(stateListener);
    }

    public boolean removeStateListener(StateListenerIF stateListener) {
        return this.compositeStateListener.removeListener(stateListener);
    }

    public void setConnectionListener(ConnectionListenerIF connectionListener) {
        this.addConnectionListener(connectionListener);
    }

    public void addConnectionListener(ConnectionListenerIF connectionListener) {
        this.compositeConnectionListener.addListener(connectionListener);
    }

    public boolean removeConnectionListener(ConnectionListenerIF connectionListener) {
        return this.compositeConnectionListener.removeListener(connectionListener);
    }

    protected void onBirth(Connection connection) throws SQLException {
        this.compositeConnectionListener.onBirth(connection);
    }

    protected void onDeath(Connection connection, int reasonCode) throws SQLException {
        this.compositeConnectionListener.onDeath(connection, reasonCode);
    }

    protected void onExecute(String command, long elapsedTime, Exception exception) throws SQLException {
        if (exception == null) {
            this.compositeConnectionListener.onExecute(command, elapsedTime);
        } else {
            this.compositeConnectionListener.onFail(command, exception);
        }
    }

    protected boolean isConnectionListenedTo() {
        return !this.compositeConnectionListener.isEmpty();
    }

    public String toString() {
        return this.getDefinition().toString();
    }

    public int getUpState() {
        return this.upState;
    }

    public void setUpState(int upState) {
        if (this.upState != upState) {
            this.compositeStateListener.upStateChanged(upState);
            this.upState = upState;
        }
    }

    protected Collection getConnectionInfos() {
        TreeSet<ConnectionInfo> cis = null;
        cis = new TreeSet<ConnectionInfo>();
        Iterator i = this.proxyConnections.iterator();
        while (i.hasNext()) {
            ConnectionInfoIF connectionInfo = (ConnectionInfoIF)i.next();
            ConnectionInfo ci = new ConnectionInfo();
            ci.setAge(connectionInfo.getAge());
            ci.setBirthDate(connectionInfo.getBirthDate());
            ci.setId(connectionInfo.getId());
            ci.setMark(connectionInfo.getMark());
            ci.setRequester(connectionInfo.getRequester());
            ci.setStatus(connectionInfo.getStatus());
            ci.setTimeLastStartActive(connectionInfo.getTimeLastStartActive());
            ci.setTimeLastStopActive(connectionInfo.getTimeLastStopActive());
            ci.setDelegateUrl(connectionInfo.getDelegateUrl());
            ci.setProxyHashcode(connectionInfo.getProxyHashcode());
            ci.setDelegateHashcode(connectionInfo.getDelegateHashcode());
            String[] sqlCalls = connectionInfo.getSqlCalls();
            for (int j = 0; j < sqlCalls.length; ++j) {
                ci.addSqlCall(sqlCalls[j]);
            }
            cis.add(ci);
        }
        return cis;
    }

    public boolean expireConnection(long id, boolean forceExpiry) {
        boolean success = false;
        ProxyConnection proxyConnection = null;
        for (int connectionsTried = 0; connectionsTried < this.proxyConnections.size(); ++connectionsTried) {
            try {
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            catch (IndexOutOfBoundsException e) {
                this.nextAvailableConnection = 0;
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            if (proxyConnection.getId() == id) {
                proxyConnection.setStatus(1, 3);
                proxyConnection.setStatus(3, 0);
                this.removeProxyConnection(proxyConnection, 2, "it was manually killed", forceExpiry, true);
                success = true;
                break;
            }
            ++this.nextAvailableConnection;
        }
        if (!success && this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.displayStatistics() + " - couldn't find " + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " and I've just been asked to expire it"));
        }
        return success;
    }

    public Log getLog() {
        return this.log;
    }

    protected void initialiseConnectionResetter(Connection connection) {
        this.connectionResetter.initialise(connection);
    }

    protected boolean resetConnection(Connection connection, String id) throws SQLException {
        if (connection.isClosed()) {
            return false;
        }
        return this.connectionResetter.reset(connection, id);
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    protected Admin getAdmin() {
        return this.admin;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void lock() {
        this.locked = true;
    }

    protected void unlock() {
        this.locked = false;
    }

    protected void acquirePrimaryReadLock() throws InterruptedException {
        this.primaryReadWriteLock.readLock().acquire();
    }

    protected void releasePrimaryReadLock() {
        this.primaryReadWriteLock.readLock().release();
    }

    protected void acquirePrimaryWriteLock() throws InterruptedException {
        this.primaryReadWriteLock.writeLock().acquire();
    }

    protected void releasePrimaryWriteLock() {
        this.primaryReadWriteLock.writeLock().release();
    }

    protected boolean isConnectionPoolUp() {
        return this.connectionPoolUp;
    }

    protected long getTimeOfLastRefusal() {
        return this.timeOfLastRefusal;
    }

    protected void acquireConnectionStatusWriteLock() {
        try {
            this.connectionStatusReadWriteLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Couldn't acquire connectionStatus write lock", (Throwable)e);
        }
    }

    protected void releaseConnectionStatusWriteLock() {
        this.connectionStatusReadWriteLock.writeLock().release();
    }

    protected void acquireConnectionStatusReadLock() {
        try {
            this.connectionStatusReadWriteLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Couldn't acquire connectionStatus read lock", (Throwable)e);
        }
    }

    protected boolean attemptConnectionStatusReadLock(long msecs) {
        try {
            return this.connectionStatusReadWriteLock.readLock().attempt(msecs);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Couldn't acquire connectionStatus read lock", (Throwable)e);
            return false;
        }
    }

    protected void releaseConnectionStatusReadLock() {
        this.connectionStatusReadWriteLock.readLock().release();
    }

    protected Prototyper getPrototyper() {
        return this.prototyper;
    }

    public long getConnectionCount() {
        return this.getPrototyper().getConnectionCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

