/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XATransactionImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class XATransactionHolder
implements DataSerializable {
    String txnId;
    SerializableXID xid;
    String ownerUuid;
    long timeoutMilis;
    long startTime;
    List<TransactionLog> txLogs;

    public XATransactionHolder() {
    }

    public XATransactionHolder(XATransactionImpl xaTransaction) {
        this.txnId = xaTransaction.getTxnId();
        this.xid = xaTransaction.getXid();
        this.ownerUuid = xaTransaction.getOwnerUuid();
        this.timeoutMilis = xaTransaction.getTimeoutMillis();
        this.startTime = xaTransaction.getStartTime();
        this.txLogs = xaTransaction.getTxLogs();
    }

    public XATransactionHolder(String txnId, SerializableXID xid, String ownerUuid, long timeoutMilis, long startTime, List<TransactionLog> txLogs) {
        this.txnId = txnId;
        this.xid = xid;
        this.ownerUuid = ownerUuid;
        this.timeoutMilis = timeoutMilis;
        this.startTime = startTime;
        this.txLogs = txLogs;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.txnId);
        out.writeObject(this.xid);
        out.writeUTF(this.ownerUuid);
        out.writeLong(this.timeoutMilis);
        out.writeLong(this.startTime);
        int len = this.txLogs.size();
        out.writeInt(len);
        if (len > 0) {
            for (TransactionLog txLog : this.txLogs) {
                out.writeObject(txLog);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.txnId = in.readUTF();
        this.xid = (SerializableXID)in.readObject();
        this.ownerUuid = in.readUTF();
        this.timeoutMilis = in.readLong();
        this.startTime = in.readLong();
        int size = in.readInt();
        this.txLogs = new ArrayList<TransactionLog>(size);
        for (int i = 0; i < size; ++i) {
            TransactionLog txLog = (TransactionLog)in.readObject();
            this.txLogs.add(txLog);
        }
    }
}

