/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.exception.RetryableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;

public class MemberLeftException
extends ExecutionException
implements RetryableException {
    private transient Member member;

    public MemberLeftException() {
    }

    public MemberLeftException(Member member) {
        super(member + " has left cluster!");
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.member.getUuid());
        boolean isImpl = this.member instanceof MemberImpl;
        out.writeBoolean(isImpl);
        if (isImpl) {
            MemberImpl memberImpl = (MemberImpl)this.member;
            Address address = memberImpl.getAddress();
            String host = address.getHost();
            int port = address.getPort();
            out.writeUTF(host);
            out.writeInt(port);
        } else {
            InetSocketAddress socketAddress = this.member.getSocketAddress();
            out.writeObject(socketAddress);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String uuid = in.readUTF();
        boolean isImpl = in.readBoolean();
        if (isImpl) {
            String host = in.readUTF();
            int port = in.readInt();
            this.member = new MemberImpl(new Address(host, port), false, uuid, null);
        } else {
            InetSocketAddress socketAddress = (InetSocketAddress)in.readObject();
            this.member = new MemberImpl(new Address(socketAddress), false, uuid, null);
        }
    }
}

