/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.MapRecordKey;
import com.hazelcast.map.tx.MapTxnOperation;
import com.hazelcast.map.tx.TxnPrepareOperation;
import com.hazelcast.map.tx.TxnRollbackOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.util.concurrent.Future;

public class MapTransactionLog
implements KeyAwareTransactionLog {
    String name;
    Data key;
    long threadId = ThreadUtil.getThreadId();
    String ownerUuid;
    Operation op;

    public MapTransactionLog() {
    }

    public MapTransactionLog(String name, Data key, Operation op, long version, String ownerUuid) {
        this.name = name;
        this.key = key;
        if (!(op instanceof MapTxnOperation)) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        this.ownerUuid = ownerUuid;
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) throws TransactionException {
        TxnPrepareOperation operation = new TxnPrepareOperation(this.name, this.key, this.ownerUuid);
        operation.setThreadId(this.threadId);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            return nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        MapTxnOperation txnOp = (MapTxnOperation)((Object)this.op);
        txnOp.setThreadId(this.threadId);
        txnOp.setOwnerUuid(this.ownerUuid);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            return nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", this.op, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
        TxnRollbackOperation operation = new TxnRollbackOperation(this.name, this.key, this.ownerUuid);
        operation.setThreadId(this.threadId);
        try {
            return nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        boolean isNullKey = this.key == null;
        out.writeBoolean(isNullKey);
        if (!isNullKey) {
            this.key.writeData(out);
        }
        out.writeLong(this.threadId);
        out.writeUTF(this.ownerUuid);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        boolean isNullKey = in.readBoolean();
        if (!isNullKey) {
            this.key = new Data();
            this.key.readData(in);
        }
        this.threadId = in.readLong();
        this.ownerUuid = in.readUTF();
        this.op = (Operation)in.readObject();
    }

    @Override
    public Object getKey() {
        return new MapRecordKey(this.name, this.key);
    }
}

