/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.File;
import java.io.IOException;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.LaunchService;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class WinLaunchService
implements LaunchService {
    private static final String LINK_FILE_SUFFIX = ".lnk";

    private boolean isLinkFile(File file) {
        return file.getPath().toLowerCase().endsWith(LINK_FILE_SUFFIX);
    }

    public File resolveLinkFile(File file) {
        String string;
        String string2;
        File file2 = file;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isLinkFile(file2) && (string2 = WinAPIWrapper.WinResolveLinkFile(string = file2.toString())) != null) {
            file2 = new File(string2);
        }
        return file2;
    }

    public void open(File file) throws LaunchFailedException {
        if (file.isDirectory()) {
            if (!WinAPIWrapper.WinShellExecute(file.toString(), "open")) {
                throw new LaunchFailedException("Failed to open the given directory.");
            }
            return;
        }
        boolean bl = false;
        String string = WinUtility.getVerbCommand(file, "opennew");
        if (string != null) {
            bl = true;
        } else {
            string = WinUtility.getVerbCommand(file, "open");
        }
        if (string != null) {
            boolean bl2 = bl ? WinAPIWrapper.WinShellExecute(file.toString(), "opennew") : WinAPIWrapper.WinShellExecute(file.toString(), "open");
            if (!bl2) {
                throw new LaunchFailedException("Failed to launch the associationed application");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }

    public boolean isEditable(File file) {
        String string = WinUtility.getVerbCommand(file, "edit");
        return string != null;
    }

    public void edit(File file) throws LaunchFailedException {
        if (this.isEditable(file)) {
            boolean bl = WinAPIWrapper.WinShellExecute(file.toString(), "edit");
            if (!bl) {
                throw new LaunchFailedException("Failed to edit the file.");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }

    public boolean isPrintable(File file) {
        String string = WinUtility.getVerbCommand(file, "print");
        return string != null;
    }

    public void print(File file) throws LaunchFailedException {
        if (this.isPrintable(file)) {
            boolean bl = WinAPIWrapper.WinShellExecute(file.toString(), "print");
            if (!bl) {
                throw new LaunchFailedException("Failed to print the file.");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }
}

