/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.sip;

import com.rayo.core.sip.BaseURI;
import com.rayo.core.sip.SipGrammar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SipURI
extends BaseURI {
    static final long serialVersionUID = 5118485527934946592L;
    public static final String TRANSPORT_PARAM = "transport";
    public static final String TTL_PARAM = "ttl";
    public static final String MADDR_PARAM = "maddr";
    public static final String METHOD_PARAM = "method";
    public static final String USER_PARAM = "user";
    public static final String LR_PARAM = "lr";
    private String _user;
    private String _password;
    private String _host;
    private String _scheme;
    private String _uri;
    private int _port;
    private HashMap<String, String> _params = new HashMap();
    private HashMap<String, String> _headers = new HashMap();

    public SipURI(String uri) {
        this._uri = uri;
        this.parse();
    }

    public SipURI(String user, String host, int port) {
        if (user != null) {
            this._user = SipGrammar.unescape(user);
        }
        this.setHost(host);
        this._port = port;
        this._scheme = "sip";
    }

    public Map<String, String> getParameters() {
        return this._params;
    }

    private void parse() {
        int endHost;
        int indexHost;
        int indexScheme = this._uri.indexOf(58);
        if (indexScheme < 0) {
            throw new IllegalArgumentException("Missing SIP scheme. URI=[" + this._uri + "]");
        }
        this._scheme = this._uri.substring(0, indexScheme);
        if (!this._scheme.equals("sip") && !this._scheme.equals("sips")) {
            throw new IllegalArgumentException("Invalid SIP scheme. URI=[" + this._uri + "]");
        }
        int indexUser = this._uri.indexOf(64, indexScheme + 1);
        if (indexUser >= 0) {
            String sUser;
            int indexPassword = this._uri.indexOf(58, indexScheme + 1);
            if (indexPassword >= 0 && indexPassword < indexUser) {
                sUser = this._uri.substring(indexScheme + 1, indexPassword);
                String sPassword = this._uri.substring(indexPassword + 1, indexUser);
                if (!SipGrammar.__passwd.containsAll(sPassword)) {
                    throw new IllegalArgumentException("Invalid password [" + sPassword + "] in URI [" + this._uri + "]");
                }
                this._password = SipGrammar.unescape(sPassword);
            } else {
                sUser = this._uri.substring(indexScheme + 1, indexUser);
            }
            if (!SipGrammar.__user.containsAll(sUser)) {
                throw new IllegalArgumentException("Invalid user [" + sUser + "] in URI [" + this._uri + "]");
            }
            this._user = SipGrammar.unescape(sUser);
            indexHost = indexUser + 1;
        } else {
            indexHost = indexScheme + 1;
        }
        int indexPort = -1;
        if (this._uri.charAt(indexHost) == '[') {
            int i = this._uri.indexOf(93, indexHost);
            if (i < 0) {
                throw new IllegalArgumentException("Invalid IPv6 in " + this._uri);
            }
            indexPort = this._uri.indexOf(58, i);
        } else {
            indexPort = this._uri.indexOf(58, indexHost);
        }
        int indexParams = this._uri.indexOf(59, indexHost);
        int indexHeaders = this._uri.indexOf(63, indexHost);
        if (indexPort > indexParams && indexParams > -1 || indexPort > indexHeaders && indexHeaders > -1) {
            indexPort = -1;
        }
        if ((endHost = indexPort) < 0) {
            endHost = indexParams;
        }
        if (endHost < 0) {
            endHost = indexHeaders;
        }
        String host = endHost < 0 ? this._uri.substring(indexHost) : this._uri.substring(indexHost, endHost);
        if (!SipGrammar.__host.containsAll(host = host.trim())) {
            throw new IllegalArgumentException("Invalid host [" + host + "] in URI [" + this._uri + "]");
        }
        this.setHost(host);
        if (indexPort < 0) {
            this._port = -1;
        } else {
            int endPort = indexParams;
            if (endPort < 0) {
                endPort = indexHeaders;
            }
            String sPort = endPort < 0 ? this._uri.substring(indexPort + 1) : this._uri.substring(indexPort + 1, endPort);
            try {
                this._port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException _) {
                throw new IllegalArgumentException("Invalid port number [" + sPort + "] in [" + this._uri + "]");
            }
        }
        if (indexParams >= 0) {
            String params = indexHeaders < 0 ? this._uri.substring(indexParams + 1) : this._uri.substring(indexParams + 1, indexHeaders);
            this.parseParams(params);
        }
        if (indexHeaders >= 0) {
            String headers = this._uri.substring(indexHeaders + 1);
            this.parseHeaders(headers);
        }
    }

    private void parseParams(String sParams) {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            if (!SipGrammar.__param.containsAll(name)) {
                throw new IllegalArgumentException("Invalid parameter name [" + name + "] in [" + this._uri + "]");
            }
            if (!SipGrammar.__param.containsAll(value)) {
                throw new IllegalArgumentException("Invalid parameter value [" + value + "] in [" + this._uri + "]");
            }
            this._params.put(SipGrammar.unescape(name.toLowerCase()), SipGrammar.unescape(value));
        }
    }

    private void parseHeaders(String sHeaders) {
        StringTokenizer st = new StringTokenizer(sHeaders, "&");
        while (st.hasMoreTokens()) {
            String header = st.nextToken();
            int index = header.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Missing value in header [" + header + "] in uri [" + this._uri + "]");
            }
            String name = header.substring(0, index).trim();
            String value = header.substring(index + 1).trim();
            if (!SipGrammar.__header.containsAll(name)) {
                throw new IllegalArgumentException("Invalid header name [" + name + "] in [" + this._uri + "]");
            }
            if (!SipGrammar.__header.containsAll(value)) {
                throw new IllegalArgumentException("Invalid header value [" + value + "] in [" + this._uri + "]");
            }
            this._headers.put(SipGrammar.unescape(name), SipGrammar.unescape(value));
        }
    }

    @Override
    public boolean isSipURI() {
        return true;
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    public boolean isSecure() {
        return "sips".equals(this._scheme);
    }

    public void setSecure(boolean b) {
        this._scheme = b ? "sips" : "sip";
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getUserPassword() {
        return this._password;
    }

    public void setUserPassword(String password) {
        this._password = password;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host.contains(":") && !host.contains("[") ? "[" + host + "]" : host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port < 0 ? -1 : port;
    }

    @Override
    public String getParameter(String name) {
        return this._params.get(name.toLowerCase());
    }

    @Override
    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        this._params.put(name.toLowerCase(), value);
    }

    @Override
    public void removeParameter(String name) {
        this._params.remove(name.toLowerCase());
    }

    @Override
    public synchronized Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }

    public String getTransportParam() {
        return this.getParameter(TRANSPORT_PARAM);
    }

    public void setTransportParam(String transport) {
        this.setParameter(TRANSPORT_PARAM, transport);
    }

    public String getMAddrParam() {
        return this.getParameter(MADDR_PARAM);
    }

    public void setMAddrParam(String maddr) {
        this.setParameter(MADDR_PARAM, maddr);
    }

    public String getMethodParam() {
        return this.getParameter(METHOD_PARAM);
    }

    public void setMethodParam(String method) {
        this.setParameter(METHOD_PARAM, method);
    }

    public int getTTLParam() {
        String ttl = this.getParameter(TTL_PARAM);
        if (ttl != null) {
            try {
                return Integer.parseInt(ttl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setTTLParam(int ttl) {
        if (ttl < 0) {
            this.removeParameter(TTL_PARAM);
        } else {
            this.setParameter(TTL_PARAM, String.valueOf(ttl));
        }
    }

    public String getUserParam() {
        return this.getParameter(USER_PARAM);
    }

    public void setUserParam(String user) {
        this.setParameter(USER_PARAM, user);
    }

    public boolean getLrParam() {
        return this.getParameter(LR_PARAM) != null;
    }

    public void setLrParam(boolean b) {
        if (b) {
            this.setParameter(LR_PARAM, "");
        } else {
            this.removeParameter(LR_PARAM);
        }
    }

    public synchronized Iterator<String> getHeaderNames() {
        return this._headers.keySet().iterator();
    }

    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        return this._headers.get(name);
    }

    public void setHeader(String name, String value) {
        this._headers.put(name, value);
    }

    public void clearHeaders() {
        this._headers = new HashMap();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this._scheme);
        sb.append(':');
        if (this._user != null) {
            sb.append(SipGrammar.escape(this._user, SipGrammar.__user));
            if (this._password != null) {
                sb.append(':');
                sb.append(SipGrammar.escape(this._password, SipGrammar.__passwd));
            }
            sb.append('@');
        }
        sb.append(this._host);
        if (this._port > -1) {
            sb.append(':');
            sb.append(this._port);
        }
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(SipGrammar.escape(name, SipGrammar.__param));
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(SipGrammar.escape(value, SipGrammar.__param));
        }
        Iterator<String> it2 = this.getHeaderNames();
        boolean first = true;
        while (it2.hasNext()) {
            String name = it2.next();
            String value = this.getHeader(name);
            if (first) {
                first = false;
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append(SipGrammar.escape(name, SipGrammar.__header));
            sb.append('=');
            sb.append(SipGrammar.escape(value, SipGrammar.__header));
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof SipURI)) {
            return false;
        }
        SipURI other = (SipURI)o;
        if (!this._scheme.equals(other.getScheme())) {
            return false;
        }
        if (!this.equalsUser(other)) {
            return false;
        }
        if (!this.equalsPassword(other)) {
            return false;
        }
        if (!this._host.equalsIgnoreCase(other.getHost())) {
            return false;
        }
        if (this._port != other.getPort()) {
            return false;
        }
        HashMap<String, String> otherParams = new HashMap<String, String>();
        Iterator<String> it = other.getParameterNames();
        while (it.hasNext()) {
            String key = it.next();
            otherParams.put(key, other.getParameter(key));
        }
        if (!this.equalsParameters(this._params, otherParams)) {
            return false;
        }
        if (!this.equalsParameters(otherParams, this._params)) {
            return false;
        }
        return this.equalsHeaders(other);
    }

    private boolean equalsUser(SipURI other) {
        if (this._user == null && other.getUser() == null) {
            return true;
        }
        if (this._user != null && other.getUser() != null) {
            return this._user.equals(other.getUser());
        }
        return false;
    }

    private boolean equalsPassword(SipURI other) {
        if (this._password == null && other.getUserPassword() == null) {
            return true;
        }
        if (this._password != null && other.getUserPassword() != null) {
            return this._password.equals(other.getUserPassword());
        }
        return false;
    }

    private boolean equalsParameters(Map<String, String> m1, Map<String, String> m2) {
        for (String name : m1.keySet()) {
            String value2;
            String value1;
            if (!m2.containsKey(name) || (value1 = m1.get(name)).equalsIgnoreCase(value2 = m2.get(name))) continue;
            return false;
        }
        if (m1.containsKey(USER_PARAM) && !m2.containsKey(USER_PARAM)) {
            return false;
        }
        if (m1.containsKey(TTL_PARAM) && !m2.containsKey(TTL_PARAM)) {
            return false;
        }
        if (m1.containsKey(METHOD_PARAM) && !m2.containsKey(METHOD_PARAM)) {
            return false;
        }
        if (m1.containsKey(MADDR_PARAM) && !m2.containsKey(MADDR_PARAM)) {
            return false;
        }
        return !m1.containsKey(TRANSPORT_PARAM) || m2.containsKey(TRANSPORT_PARAM);
    }

    private boolean equalsHeaders(SipURI other) {
        Iterator<String> it = other.getHeaderNames();
        int i = 0;
        while (it.hasNext()) {
            String name = it.next();
            if (this._headers.containsKey(name)) {
                if (!this._headers.get(name).equalsIgnoreCase(other.getHeader(name))) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return this._headers.size() == i;
    }

    public void removeHeader(String name) {
        this._headers.remove(name);
    }
}

