/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.impl.ClientDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class ClientResponse
implements IdentifiedDataSerializable {
    private Data response;
    private int callId;
    private boolean isError;

    public ClientResponse() {
    }

    public ClientResponse(Data response, int callId, boolean isError) {
        this.response = response;
        this.callId = callId;
        this.isError = isError;
    }

    public Data getResponse() {
        return this.response;
    }

    public int getCallId() {
        return this.callId;
    }

    public boolean isError() {
        return this.isError;
    }

    @Override
    public int getFactoryId() {
        return ClientDataSerializerHook.ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.callId);
        out.writeBoolean(this.isError);
        out.writeData(this.response);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.callId = in.readInt();
        this.isError = in.readBoolean();
        this.response = in.readData();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientResponse{");
        sb.append("callId=").append(this.callId);
        sb.append(", isError=").append(this.isError);
        sb.append('}');
        return sb.toString();
    }
}

