/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import javax.ws.rs.WebApplicationException;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.BindingBuilderFactory;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;

public class Injections {
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();

    public static DynamicConfiguration getConfiguration(ServiceLocator locator) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        return dcs.createDynamicConfiguration();
    }

    public static ServiceLocator createLocator(String name, ServiceLocator parent, Binder ... binders) {
        return Injections._createLocator(name, parent, binders);
    }

    public static ServiceLocator createLocator(String name, Binder ... binders) {
        return Injections._createLocator(name, null, binders);
    }

    public static ServiceLocator createLocator(ServiceLocator parent, Binder ... binders) {
        return Injections._createLocator(null, parent, binders);
    }

    public static ServiceLocator createLocator(Binder ... binders) {
        return Injections._createLocator(null, null, binders);
    }

    private static ServiceLocator _createLocator(String name, ServiceLocator parent, Binder ... binders) {
        ServiceLocator result = factory.create(name, parent, null, ServiceLocatorFactory.CreatePolicy.DESTROY);
        result.setNeutralContextClassLoader(false);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)result);
        for (Binder binder : binders) {
            Injections.bind(result, binder);
        }
        return result;
    }

    private static void bind(ServiceLocator locator, Binder binder) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        locator.inject((Object)binder);
        binder.bind(dc);
        dc.commit();
    }

    public static <T> T getOrCreate(ServiceLocator serviceLocator, Class<T> clazz) {
        try {
            Object component = serviceLocator.getService(clazz, new Annotation[0]);
            return (T)(component == null ? serviceLocator.createAndInitialize(clazz) : component);
        }
        catch (MultiException e) {
            for (Throwable t : e.getErrors()) {
                if (!WebApplicationException.class.isAssignableFrom(t.getClass())) continue;
                throw (WebApplicationException)t;
            }
            throw e;
        }
    }

    public static void addBinding(BindingBuilder<?> builder, DynamicConfiguration configuration) {
        BindingBuilderFactory.addBinding(builder, (DynamicConfiguration)configuration);
    }

    public static void addBinding(BindingBuilder<?> builder, DynamicConfiguration configuration, HK2Loader defaultLoader) {
        BindingBuilderFactory.addBinding(builder, (DynamicConfiguration)configuration, (HK2Loader)defaultLoader);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Class<? extends Factory<T>> factoryType, Class<? extends Annotation> factoryScope) {
        return BindingBuilderFactory.newFactoryBinder(factoryType, factoryScope);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Class<? extends Factory<T>> factoryType) {
        return BindingBuilderFactory.newFactoryBinder(factoryType);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Factory<T> factory) {
        return BindingBuilderFactory.newFactoryBinder(factory);
    }

    public static <T> ServiceBindingBuilder<T> newBinder(Class<T> serviceType) {
        return BindingBuilderFactory.newBinder(serviceType);
    }

    public static <T> ScopedBindingBuilder<T> newBinder(T service) {
        return BindingBuilderFactory.newBinder(service);
    }

    public static void shutdownLocator(ServiceLocator locator) {
        if (factory.find(locator.getName()) != null) {
            factory.destroy(locator.getName());
        } else {
            locator.shutdown();
        }
    }
}

