/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ElGamalParameters elGamalParameters = this.param.getParameters();
        BigInteger bigInteger = elGamalParameters.getP();
        BigInteger bigInteger2 = this.helper.calculatePrivate(bigInteger, this.param.getRandom(), elGamalParameters.getL());
        BigInteger bigInteger3 = this.helper.calculatePublic(bigInteger, elGamalParameters.getG(), bigInteger2);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger3, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger2, elGamalParameters));
    }
}

