/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiatorManager;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.Bytestream;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    protected static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private static final int CONNECT_FAILURE_THRESHOLD = 2;
    public static boolean isAllowLocalProxyHost = true;
    private final XMPPConnection connection;
    private Socks5TransferNegotiatorManager transferNegotiatorManager;

    public Socks5TransferNegotiator(Socks5TransferNegotiatorManager transferNegotiatorManager, XMPPConnection connection) {
        this.connection = connection;
        this.transferNegotiatorManager = transferNegotiatorManager;
    }

    public PacketFilter getInitiationPacketFilter(String from, String sessionID) {
        return new AndFilter(new FromMatchesFilter(from), new BytestreamSIDFilter(sessionID));
    }

    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        SelectedHostInfo selectedHost;
        Bytestream streamHostsInfo = (Bytestream)streamInitiation;
        if (streamHostsInfo.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(streamHostsInfo.getError());
        }
        try {
            selectedHost = this.selectHost(streamHostsInfo);
        }
        catch (XMPPException ex) {
            if (ex.getXMPPError() != null) {
                IQ errorPacket = super.createError(streamHostsInfo.getTo(), streamHostsInfo.getFrom(), streamHostsInfo.getPacketID(), ex.getXMPPError());
                this.connection.sendPacket(errorPacket);
            }
            throw ex;
        }
        Bytestream streamResponse = this.createUsedHostConfirmation(selectedHost.selectedHost, streamHostsInfo.getFrom(), streamHostsInfo.getTo(), streamHostsInfo.getPacketID());
        this.connection.sendPacket(streamResponse);
        try {
            PushbackInputStream stream = new PushbackInputStream(selectedHost.establishedSocket.getInputStream());
            int firstByte = stream.read();
            stream.unread(firstByte);
            return stream;
        }
        catch (IOException e) {
            throw new XMPPException("Error establishing input stream", e);
        }
    }

    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        Packet streamInitiation = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    private Bytestream createUsedHostConfirmation(Bytestream.StreamHost selectedHost, String initiator, String target, String packetID) {
        Bytestream streamResponse = new Bytestream();
        streamResponse.setTo(initiator);
        streamResponse.setFrom(target);
        streamResponse.setType(IQ.Type.RESULT);
        streamResponse.setPacketID(packetID);
        streamResponse.setUsedHost(selectedHost.getJID());
        return streamResponse;
    }

    private SelectedHostInfo selectHost(Bytestream streamHostsInfo) throws XMPPException {
        Iterator<Bytestream.StreamHost> it = streamHostsInfo.getStreamHosts().iterator();
        Bytestream.StreamHost selectedHost = null;
        Socket socket = null;
        while (it.hasNext()) {
            selectedHost = it.next();
            String address = selectedHost.getAddress();
            int failures = this.getConnectionFailures(address);
            if (failures >= 2) continue;
            try {
                socket = new Socket(address, selectedHost.getPort());
                this.establishSOCKS5ConnectionToProxy(socket, this.createDigest(streamHostsInfo.getSessionID(), streamHostsInfo.getFrom(), streamHostsInfo.getTo()));
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.incrementConnectionFailures(address);
                selectedHost = null;
                socket = null;
            }
        }
        if (selectedHost == null || socket == null || !socket.isConnected()) {
            String errorMessage = "Could not establish socket with any provided host";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.no_acceptable, errorMessage));
        }
        return new SelectedHostInfo(selectedHost, socket);
    }

    private void incrementConnectionFailures(String address) {
        this.transferNegotiatorManager.incrementConnectionFailures(address);
    }

    private int getConnectionFailures(String address) {
        return this.transferNegotiatorManager.getConnectionFailures(address);
    }

    private String createDigest(String sessionID, String initiator, String target) {
        return StringUtils.hash(sessionID + StringUtils.parseName(initiator) + "@" + StringUtils.parseServer(initiator) + "/" + StringUtils.parseResource(initiator) + StringUtils.parseName(target) + "@" + StringUtils.parseServer(target) + "/" + StringUtils.parseResource(target));
    }

    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        Socket socket;
        try {
            socket = this.initBytestreamSocket(streamID, initiator, target);
        }
        catch (Exception e) {
            throw new XMPPException("Error establishing transfer socket", e);
        }
        if (socket != null) {
            try {
                return new BufferedOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                throw new XMPPException("Error establishing output stream", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket initBytestreamSocket(String sessionID, String initiator, String target) throws Exception {
        Socket conn;
        Socks5TransferNegotiatorManager.ProxyProcess process;
        try {
            process = this.establishListeningSocket();
        }
        catch (IOException io) {
            process = null;
        }
        try {
            String localIP;
            try {
                localIP = this.discoverLocalIP();
            }
            catch (UnknownHostException e1) {
                localIP = null;
            }
            Bytestream query = this.createByteStreamInit(initiator, target, sessionID, localIP, process != null ? process.getPort() : 0);
            conn = this.waitForUsedHostResponse((String)sessionID, (Socks5TransferNegotiatorManager.ProxyProcess)process, (String)this.createDigest((String)sessionID, (String)initiator, (String)target), (Bytestream)query).establishedSocket;
        }
        finally {
            this.cleanupListeningSocket();
        }
        return conn;
    }

    private SelectedHostInfo waitForUsedHostResponse(String sessionID, Socks5TransferNegotiatorManager.ProxyProcess proxy, String digest, Bytestream query) throws XMPPException, IOException {
        SelectedHostInfo info = new SelectedHostInfo();
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(query.getPacketID()));
        this.connection.sendPacket(query);
        Packet packet = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (packet == null || !(packet instanceof Bytestream)) {
            throw new XMPPException("Unexpected response from remote user");
        }
        Bytestream response = (Bytestream)packet;
        if (response.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException("Remote client returned error, stream hosts expected", response.getError());
        }
        Bytestream.StreamHostUsed used = response.getUsedHost();
        Bytestream.StreamHost usedHost = query.getStreamHost(used.getJID());
        if (usedHost == null) {
            throw new XMPPException("Remote user responded with unknown host");
        }
        if (used.getJID().equals(query.getFrom())) {
            info.establishedSocket = proxy.getSocket(digest);
            info.selectedHost = usedHost;
            return info;
        }
        info.establishedSocket = new Socket(usedHost.getAddress(), usedHost.getPort());
        this.establishSOCKS5ConnectionToProxy(info.establishedSocket, digest);
        Bytestream activate = Socks5TransferNegotiator.createByteStreamActivate(sessionID, response.getTo(), usedHost.getJID(), response.getFrom());
        collector = this.connection.createPacketCollector(new PacketIDFilter(activate.getPacketID()));
        this.connection.sendPacket(activate);
        IQ serverResponse = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (!serverResponse.getType().equals(IQ.Type.RESULT)) {
            info.establishedSocket.close();
            return null;
        }
        return info;
    }

    private Socks5TransferNegotiatorManager.ProxyProcess establishListeningSocket() throws IOException {
        return this.transferNegotiatorManager.addTransfer();
    }

    private void cleanupListeningSocket() {
        this.transferNegotiatorManager.removeTransfer();
    }

    private String discoverLocalIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private Bytestream createByteStreamInit(String from, String to, String sid, String localIP, int port) {
        Collection<Bytestream.StreamHost> streamHosts;
        Bytestream bs = new Bytestream();
        bs.setTo(to);
        bs.setFrom(from);
        bs.setSessionID(sid);
        bs.setType(IQ.Type.SET);
        bs.setMode(Bytestream.Mode.tcp);
        if (localIP != null && port > 0) {
            bs.addStreamHost(from, localIP, port);
        }
        if ((streamHosts = this.transferNegotiatorManager.getStreamHosts()) != null) {
            for (Bytestream.StreamHost host : streamHosts) {
                bs.addStreamHost(host);
            }
        }
        return bs;
    }

    private static Bytestream createByteStreamActivate(String sessionID, String from, String to, String target) {
        Bytestream activate = new Bytestream(sessionID);
        activate.setMode(null);
        activate.setToActivate(target);
        activate.setFrom(from);
        activate.setTo(to);
        activate.setType(IQ.Type.SET);
        return activate;
    }

    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    private void establishSOCKS5ConnectionToProxy(Socket socket, String digest) throws IOException {
        byte[] cmd = new byte[]{5, 1, 0};
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        ((OutputStream)out).write(cmd);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        byte[] response = new byte[2];
        ((InputStream)in).read(response);
        cmd = Socks5TransferNegotiator.createOutgoingSocks5Message(1, digest);
        ((OutputStream)out).write(cmd);
        Socks5TransferNegotiator.createIncomingSocks5Message(in);
    }

    static String createIncomingSocks5Message(InputStream in) throws IOException {
        byte[] cmd = new byte[5];
        in.read(cmd, 0, 5);
        byte[] addr = new byte[cmd[4]];
        in.read(addr, 0, addr.length);
        String digest = new String(addr);
        in.read();
        in.read();
        return digest;
    }

    static byte[] createOutgoingSocks5Message(int cmd, String digest) {
        byte[] addr = digest.getBytes();
        byte[] data = new byte[7 + addr.length];
        data[0] = 5;
        data[1] = (byte)cmd;
        data[2] = 0;
        data[3] = 3;
        data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data, 5, addr.length);
        data[data.length - 2] = 0;
        data[data.length - 1] = 0;
        return data;
    }

    public void cleanup() {
    }

    private static class BytestreamSIDFilter
    implements PacketFilter {
        private String sessionID;

        public BytestreamSIDFilter(String sessionID) {
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        public boolean accept(Packet packet) {
            if (!Bytestream.class.isInstance(packet)) {
                return false;
            }
            Bytestream bytestream = (Bytestream)packet;
            String sessionID = bytestream.getSessionID();
            return sessionID != null && sessionID.equals(this.sessionID);
        }
    }

    private static class SelectedHostInfo {
        protected XMPPException exception;
        protected Bytestream.StreamHost selectedHost;
        protected Socket establishedSocket;

        SelectedHostInfo(Bytestream.StreamHost selectedHost, Socket establishedSocket) {
            this.selectedHost = selectedHost;
            this.establishedSocket = establishedSocket;
        }

        public SelectedHostInfo() {
        }
    }
}

