/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.Properties;
import org.openymsg.network.DirectConnectionHandler;

public class SOCKSConnectionHandler
extends DirectConnectionHandler {
    private String socksHost;
    private int socksPort;

    public SOCKSConnectionHandler() throws IllegalArgumentException {
        this.socksHost = System.getProperty("socksProxyHost", "");
        this.socksPort = Integer.parseInt(System.getProperty("socksProxyPort", "-1"));
        if (this.socksHost.length() <= 0 || this.socksPort <= 0) {
            throw new IllegalArgumentException("Bad SOCKS proxy properties: " + this.socksHost + ":" + this.socksPort);
        }
        System.getProperties().put("socksProxySet", "true");
    }

    public SOCKSConnectionHandler(String string, int n) {
        this.socksHost = string;
        this.socksPort = n;
        Properties properties = System.getProperties();
        properties.put("socksProxyHost", this.socksHost);
        properties.put("socksProxyPort", this.socksPort + "");
        properties.put("socksProxySet", "true");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SOCKS connection: ").append(this.socksHost).append(":").append(this.socksPort);
        return stringBuffer.toString();
    }
}

