/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import org.openymsg.network.Status;

public class YahooUser {
    protected String id;
    protected Status status;
    protected int stealth;
    protected boolean onChat;
    protected boolean onPager;
    protected boolean ignored;
    protected boolean stealthBlock;
    protected String customStatusMessage;
    protected boolean customStatusBusy;
    private int groupCount = 0;
    private long idleTime = -1L;

    public YahooUser(String string, Status status, boolean bl, boolean bl2) {
        this.update(string, status, bl, bl2);
    }

    public YahooUser(String string) {
        this(string, Status.OFFLINE, false, false);
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public void setStealthBlocked(boolean bl) {
        this.stealthBlock = bl;
    }

    public void setCustom(String string, String string2) {
        this.customStatusMessage = string;
        this.customStatusBusy = string2.charAt(0) == '1';
    }

    public void setIdleTime(String string) {
        this.idleTime = Long.parseLong(string);
    }

    public void setStealth(int n) {
        this.stealth = n;
    }

    public void adjustGroupCount(int n) {
        this.groupCount += n;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getStealth() {
        return this.stealth;
    }

    public boolean isOnChat() {
        return this.onChat;
    }

    public boolean isOnPager() {
        return this.onPager;
    }

    public boolean isLoggedIn() {
        return this.onChat || this.onPager;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public boolean isStealthBlocked() {
        return this.stealthBlock;
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public boolean isFriend() {
        return this.groupCount > 0;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String toString() {
        return "YahooUser [ID=" + this.id + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YahooUser)) {
            return false;
        }
        return ((YahooUser)object).getId().equals(this.getId());
    }

    public int hashCode() {
        int n = 4133;
        return n *= 37 + this.id.hashCode();
    }

    public void update(String string, Status status, String string2) {
        int n = string2 == null ? 0 : Integer.parseInt(string2);
        this.update(string, status, (n & 2) > 0, (n & 1) > 0);
    }

    public void update(String string, Status status, boolean bl, boolean bl2) {
        this.id = string;
        this.status = status;
        this.onChat = bl;
        this.onPager = bl2;
        if (this.status != Status.CUSTOM) {
            this.customStatusMessage = null;
            this.customStatusBusy = false;
        }
    }
}

