/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

class PeriodicExecuter
implements Runnable {
    private boolean quitFlag = false;
    private long period;
    private Node readHead;
    private Node writeHead;
    private static final long CLOSE_ENOUGH = 100L;

    PeriodicExecuter(long l) {
        this.period = l;
        this.readHead = null;
        this.writeHead = null;
    }

    synchronized void add(Runnable runnable) {
        Node node = new Node(runnable, this.period);
        if (this.writeHead == null) {
            this.writeHead = node;
            this.readHead = node;
            node.next = node;
            node.previous = node;
        } else {
            Node node2 = this.writeHead;
            Node node3 = this.writeHead.next;
            node2.next = node;
            node.previous = node2;
            node3.previous = node;
            node.next = node3;
            this.writeHead = node;
        }
        this.notifyAll();
    }

    synchronized Runnable remove(Runnable runnable) {
        Node node;
        if (this.readHead == null) {
            return null;
        }
        Node node2 = node = this.readHead;
        while (node2.value != runnable && (node2 = node2.next) != node) {
        }
        if (node2.value != runnable) {
            return null;
        }
        if (node2 == node2.next) {
            this.readHead = null;
            this.writeHead = null;
            return node2.value;
        }
        node2.next.previous = node2.previous;
        node2.previous.next = node2.next;
        if (this.readHead == node2) {
            this.readHead = node2.next;
        }
        if (this.writeHead == node2) {
            this.writeHead = node2.next;
        }
        return node2.value;
    }

    synchronized Node read() {
        Node node = this.readHead;
        if (this.readHead != null) {
            this.readHead = this.readHead.next;
        }
        return node;
    }

    public String toString() {
        Node node;
        if (this.readHead == null) {
            return "[Empty]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Node node2 = node = this.readHead;
        do {
            if (node2 == this.readHead) {
                stringBuffer.append("[R]");
            }
            if (node2 == this.writeHead) {
                stringBuffer.append("[W]");
            }
            stringBuffer.append(node2.value).append(", ");
        } while ((node2 = node2.next) != node);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.quitFlag) {
            Node node = this.read();
            if (node != null) {
                long l = node.nextExecutionTime - System.currentTimeMillis();
                if (l > 100L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                node.value.run();
                node.nextExecutionTime += this.period;
                continue;
            }
            PeriodicExecuter periodicExecuter = this;
            synchronized (periodicExecuter) {
                if (!this.quitFlag) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class Node {
        Node next;
        Node previous;
        long nextExecutionTime;
        Runnable value;
        long period;

        Node(Runnable runnable, long l) {
            this.value = runnable;
            this.period = l;
            this.nextExecutionTime = System.currentTimeMillis() + this.period;
        }
    }
}

