/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.awt.Frame;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.ui.wizard.Wizard;
import net.sf.fmj.ui.wizards.ChooseSourcePanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.ContentDescriptorFilter;
import net.sf.fmj.ui.wizards.FileDestPanelDescriptor;
import net.sf.fmj.ui.wizards.TranscodeWizardConfig;
import net.sf.fmj.ui.wizards.TranscodeWizardResult;

public class TranscodeWizard
extends Wizard {
    private final TranscodeWizardResult result = new TranscodeWizardResult();
    private final TranscodeWizardConfig config;

    public TranscodeWizard(Frame frame, TranscodeWizardConfig transcodeWizardConfig) {
        super(frame);
        this.config = transcodeWizardConfig != null ? transcodeWizardConfig : new TranscodeWizardConfig();
        this.getDialog().setTitle("Transcode Wizard");
        ChooseSourcePanelDescriptor chooseSourcePanelDescriptor = new ChooseSourcePanelDescriptor(transcodeWizardConfig, this.result);
        this.registerWizardPanel(ChooseSourcePanelDescriptor.IDENTIFIER, chooseSourcePanelDescriptor);
        ContentAndTrackFormatPanelDescriptor contentAndTrackFormatPanelDescriptor = new ContentAndTrackFormatPanelDescriptor(FileDestPanelDescriptor.IDENTIFIER, new TranscodeContentDescriptorFilter(), transcodeWizardConfig, this.result);
        this.registerWizardPanel(ContentAndTrackFormatPanelDescriptor.IDENTIFIER, contentAndTrackFormatPanelDescriptor);
        FileDestPanelDescriptor fileDestPanelDescriptor = new FileDestPanelDescriptor(transcodeWizardConfig, this.result);
        this.registerWizardPanel(FileDestPanelDescriptor.IDENTIFIER, fileDestPanelDescriptor);
        this.setCurrentPanel(ChooseSourcePanelDescriptor.IDENTIFIER);
    }

    public TranscodeWizardConfig getConfig() {
        return this.config;
    }

    public TranscodeWizardResult getResult() {
        return this.result;
    }

    public boolean run() {
        int n = this.showModalDialog();
        return n == 0;
    }

    private static class TranscodeContentDescriptorFilter
    implements ContentDescriptorFilter {
        private TranscodeContentDescriptorFilter() {
        }

        public boolean isCompatible(ContentDescriptor contentDescriptor) {
            return contentDescriptor instanceof FileTypeDescriptor;
        }
    }
}

