/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.api.DataInfo;

public interface FlowControlStrategy {
    public int getWindowSize(ISession var1);

    public void setWindowSize(ISession var1, int var2);

    public void onNewStream(ISession var1, IStream var2);

    public void onWindowUpdate(ISession var1, IStream var2, int var3);

    public void updateWindow(ISession var1, IStream var2, int var3);

    public void onDataReceived(ISession var1, IStream var2, DataInfo var3);

    public void onDataConsumed(ISession var1, IStream var2, DataInfo var3, int var4);

    public static class None
    implements FlowControlStrategy {
        private volatile int windowSize;

        public None() {
            this(65536);
        }

        public None(int windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public int getWindowSize(ISession session) {
            return this.windowSize;
        }

        @Override
        public void setWindowSize(ISession session, int windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public void onNewStream(ISession session, IStream stream) {
            stream.updateWindowSize(this.windowSize);
        }

        @Override
        public void onWindowUpdate(ISession session, IStream stream, int delta) {
        }

        @Override
        public void updateWindow(ISession session, IStream stream, int delta) {
        }

        @Override
        public void onDataReceived(ISession session, IStream stream, DataInfo dataInfo) {
        }

        @Override
        public void onDataConsumed(ISession session, IStream stream, DataInfo dataInfo, int delta) {
        }
    }
}

