/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class UserInfoCmd
extends LocCommand {
    private final FullUserInfo userInfo;
    private final InfoData infoData;

    protected UserInfoCmd(SnacPacket packet) {
        super(6);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.userInfo = FullUserInfo.readUserInfo(snacData);
        ByteBlock infoBlock = snacData.subBlock(this.userInfo.getTotalSize());
        this.infoData = InfoData.readInfoData(infoBlock);
    }

    public UserInfoCmd(FullUserInfo userInfo, InfoData infoData) {
        super(6);
        this.userInfo = userInfo;
        this.infoData = infoData;
    }

    public final FullUserInfo getUserInfo() {
        return this.userInfo;
    }

    public final InfoData getInfoData() {
        return this.infoData;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.userInfo != null) {
            this.userInfo.write(out);
            if (this.infoData != null) {
                this.infoData.write(out);
            }
        }
    }

    public String toString() {
        return "UserInfoCmd: user=<" + this.userInfo + ">, info=<" + this.infoData + ">";
    }
}

