/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import weblogic.xml.babel.scanner.ScannerState;

public class ScannerException
extends Exception {
    int line;
    int column;
    ScannerState state;

    public ScannerException() {
        this.line = 0;
        this.column = 0;
        this.state = null;
    }

    public ScannerException(String string) {
        super(string);
        this.line = 0;
        this.column = 0;
        this.state = null;
    }

    public ScannerException(String string, int n, int n2) {
        super(string);
        this.line = n;
        this.column = n2;
    }

    public ScannerException(String string, int n, int n2, ScannerState scannerState) {
        super(string);
        this.line = n;
        this.column = n2;
        this.state = scannerState;
    }

    public ScannerException(String string, ScannerState scannerState) {
        super(string);
        this.line = scannerState.currentLine;
        this.column = scannerState.currentColumn;
        this.state = scannerState;
    }

    public String toString() {
        return "Error at line:" + this.line + " col:" + this.column + " " + this.getMessage();
    }

    public void printTokenStack() {
        if (this.state == null) {
            return;
        }
        if (this.state.hasQueuedTokens()) {
            System.out.println("Scanner has tokens:");
        } else {
            System.out.println("Scanner has no tokens:");
        }
        while (this.state.hasQueuedTokens()) {
            System.out.println("\t" + this.state.returnToken());
        }
    }

    public void printErrorLine() {
        if (this.state == null) {
            return;
        }
        int n = 20;
        System.out.println(this.state.getInputBufferContext(n));
    }
}

