/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.CharData;
import weblogic.xml.babel.scanner.Reference;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Space;

final class AttributeValue {
    private ScannerState state;
    private Reference reference;
    private CharData singleQuoteData;
    private CharData doubleQuoteData;
    private Space space;

    AttributeValue(ScannerState scannerState) {
        this.state = scannerState;
        this.reference = new Reference(scannerState);
        this.singleQuoteData = new CharData(scannerState, "<&'\r\n\t");
        this.doubleQuoteData = new CharData(scannerState, "<&\"\r\n\t");
        this.space = new Space(scannerState);
    }

    private void readSingleQuote() throws IOException, ScannerException {
        this.state.expect('\'');
        while (true) {
            boolean bl = this.singleQuoteData.read();
            if (this.state.currentChar == '&') {
                this.reference.read();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\r' || this.state.currentChar == '\n' || this.state.currentChar == '\t') {
                this.space.skipRead();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\'' || !bl) break;
        }
        this.state.expect('\'', " this attribute was not terminated by a matching single quote");
    }

    private void readDoubleQuote() throws IOException, ScannerException {
        this.state.expect('\"');
        while (true) {
            boolean bl = this.doubleQuoteData.read();
            if (this.state.currentChar == '&') {
                this.reference.read();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\r' || this.state.currentChar == '\n' || this.state.currentChar == '\t') {
                this.space.skipRead();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\"' || !bl) break;
        }
        this.state.expect('\"', " this attribute was not terminated by a matching double quote");
    }

    void read() throws IOException, ScannerException {
        if (this.state.currentChar == '\"') {
            this.readDoubleQuote();
        } else {
            this.readSingleQuote();
        }
    }
}

