/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.Serializable;

public final class UnsyncStringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;

    public UnsyncStringBuffer() {
        this(16);
    }

    public UnsyncStringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public UnsyncStringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copyWhenShared() {
        if (this.shared) {
            char[] cArray = new char[this.value.length];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity(n);
        if (this.count < n) {
            this.copyWhenShared();
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.copyWhenShared();
        this.value[n] = c;
    }

    public UnsyncStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public UnsyncStringBuffer append(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        int n = string.length();
        this.ensureCapacity(this.count + n);
        this.copyWhenShared();
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public UnsyncStringBuffer append(char[] cArray) {
        int n = cArray.length;
        this.ensureCapacity(this.count + n);
        this.copyWhenShared();
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public UnsyncStringBuffer append(char[] cArray, int n, int n2) {
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public UnsyncStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public UnsyncStringBuffer append(char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        this.value[this.count++] = c;
        return this;
    }

    public UnsyncStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public UnsyncStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public UnsyncStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public UnsyncStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public UnsyncStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public UnsyncStringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public UnsyncStringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        this.ensureCapacity(this.count + n2);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count += n2;
        return this;
    }

    public UnsyncStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public UnsyncStringBuffer insert(int n, char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public UnsyncStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public UnsyncStringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public UnsyncStringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public UnsyncStringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public UnsyncStringBuffer reverse() {
        this.copyWhenShared();
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = c;
            --n2;
        }
        return this;
    }

    public String toString() {
        this.shared = true;
        return new String(this.value, 0, this.count);
    }
}

