/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jitsi.impl.neomedia.ActiveSpeakerDetectorImpl;
import org.jitsi.impl.neomedia.DominantSpeakerIdentification;
import org.jitsi.service.neomedia.ActiveSpeakerDetector;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.event.ActiveSpeakerChangedListener;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConferenceSpeechActivity
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String DOMINANT_ENDPOINT_PROPERTY_NAME = ConferenceSpeechActivity.class.getName() + ".dominantEndpoint";
    public static final String ENDPOINTS_PROPERTY_NAME = ConferenceSpeechActivity.class.getName() + ".endpoints";
    private static final ExecutorService executorService = ExecutorUtils.newCachedThreadPool((boolean)true, (String)"ConferenceSpeechActivity");
    private static final Logger logger = Logger.getLogger(ConferenceSpeechActivity.class);
    private final ActiveSpeakerChangedListener activeSpeakerChangedListener = new ActiveSpeakerChangedListener(){

        public void activeSpeakerChanged(long ssrc) {
            ConferenceSpeechActivity.this.activeSpeakerChanged(ssrc);
        }
    };
    private ActiveSpeakerDetector activeSpeakerDetector;
    private final Object activeSpeakerDetectorSyncRoot = new Object();
    private final WeakReference<Conference> conference;
    private WeakReference<Endpoint> dominantEndpoint;
    private boolean dominantEndpointChanged = false;
    private DominantSpeakerIdentification dominantSpeakerIdentification;
    private List<WeakReference<Endpoint>> endpoints;
    private boolean endpointsChanged = false;
    private EventDispatcher eventDispatcher;
    private long eventDispatcherTime;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    private final Object syncRoot = new Object();

    private static long parseSSRC(Object obj) {
        long l = -1L;
        if (obj == null) {
            l = -1L;
        } else if (obj instanceof Number) {
            l = ((Number)obj).longValue();
        } else {
            String s = obj.toString();
            if (s == null) {
                l = -1L;
            } else {
                try {
                    l = Long.parseLong(s);
                }
                catch (NumberFormatException ex) {
                    l = -1L;
                }
            }
        }
        return l;
    }

    private void resolveSSRCAsEndpoint(JSONObject jsonObject, String ssrcKey, Conference conference, String endpointKey) {
        Endpoint endpoint;
        long ssrc = ConferenceSpeechActivity.parseSSRC(jsonObject.get((Object)ssrcKey));
        if (ssrc != -1L && (endpoint = conference.findEndpointByReceiveSSRC(ssrc, MediaType.AUDIO)) != null) {
            jsonObject.put((Object)endpointKey, (Object)endpoint.getID());
        }
    }

    public ConferenceSpeechActivity(Conference conference) {
        this.conference = new WeakReference<Conference>(conference);
        conference.addPropertyChangeListener(this.propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeSpeakerChanged(long ssrc) {
        Conference conference = this.getConference();
        if (conference != null && !conference.isExpired()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("The dominant speaker in conference " + conference.getID() + " is now the SSRC " + ssrc + "."));
            }
            Endpoint endpoint = conference.findEndpointByReceiveSSRC(ssrc, MediaType.AUDIO);
            boolean maybeStartEventDispatcher = false;
            Object object = this.syncRoot;
            synchronized (object) {
                if (endpoint == null) {
                    maybeStartEventDispatcher = true;
                } else {
                    Endpoint dominantEndpoint = this.getDominantEndpoint();
                    if (!endpoint.equals(dominantEndpoint)) {
                        this.dominantEndpoint = new WeakReference<Endpoint>(endpoint);
                        maybeStartEventDispatcher = true;
                    }
                }
                if (maybeStartEventDispatcher) {
                    this.dominantEndpointChanged = true;
                    this.maybeStartEventDispatcher();
                }
            }
        }
    }

    public JSONObject doGetDominantSpeakerIdentificationJSON() {
        JSONObject jsonObject;
        block7: {
            Conference conference;
            DominantSpeakerIdentification dominantSpeakerIdentification;
            block8: {
                block6: {
                    dominantSpeakerIdentification = this.getDominantSpeakerIdentification();
                    if (dominantSpeakerIdentification != null) break block6;
                    jsonObject = null;
                    break block7;
                }
                conference = this.getConference();
                if (conference != null && !conference.isExpired()) break block8;
                jsonObject = null;
                break block7;
            }
            jsonObject = dominantSpeakerIdentification.doGetJSON();
            if (jsonObject == null) break block7;
            this.resolveSSRCAsEndpoint(jsonObject, "dominantSpeaker", conference, "dominantEndpoint");
            Object speakers = jsonObject.get((Object)"speakers");
            if (speakers != null) {
                if (speakers instanceof JSONObject[]) {
                    for (JSONObject speaker : (JSONObject[])speakers) {
                        this.resolveSSRCAsEndpoint(speaker, "ssrc", conference, "endpoint");
                    }
                } else if (speakers instanceof JSONArray) {
                    for (Object speaker : (JSONArray)speakers) {
                        if (!(speaker instanceof JSONObject)) continue;
                        this.resolveSSRCAsEndpoint((JSONObject)speaker, "ssrc", conference, "endpoint");
                    }
                }
            }
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventDispatcherExited(EventDispatcher eventDispatcher) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.eventDispatcher == eventDispatcher) {
                this.eventDispatcher = eventDispatcher;
                this.eventDispatcherTime = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveSpeakerDetector getActiveSpeakerDetector() {
        Conference conference;
        ActiveSpeakerDetector activeSpeakerDetector;
        boolean addActiveSpeakerChangedListener = false;
        Object object = this.activeSpeakerDetectorSyncRoot;
        synchronized (object) {
            activeSpeakerDetector = this.activeSpeakerDetector;
            if (activeSpeakerDetector == null) {
                ActiveSpeakerDetectorImpl asdi = new ActiveSpeakerDetectorImpl();
                this.activeSpeakerDetector = activeSpeakerDetector = asdi;
                addActiveSpeakerChangedListener = true;
                ActiveSpeakerDetector impl = asdi.getImpl();
                this.dominantSpeakerIdentification = impl instanceof DominantSpeakerIdentification ? (DominantSpeakerIdentification)impl : null;
            }
        }
        if (addActiveSpeakerChangedListener && (conference = this.getConference()) != null && !conference.isExpired()) {
            activeSpeakerDetector.addActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
            DominantSpeakerIdentification dominantSpeakerIdentification = this.dominantSpeakerIdentification;
            if (dominantSpeakerIdentification != null) {
                dominantSpeakerIdentification.addPropertyChangeListener(this.propertyChangeListener);
            }
        }
        return activeSpeakerDetector;
    }

    private Conference getConference() {
        Conference conference = (Conference)this.conference.get();
        if (conference == null || conference.isExpired()) {
            DominantSpeakerIdentification dominantSpeakerIdentification;
            ActiveSpeakerDetector activeSpeakerDetector = this.activeSpeakerDetector;
            if (activeSpeakerDetector != null) {
                activeSpeakerDetector.removeActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
            }
            if ((dominantSpeakerIdentification = this.dominantSpeakerIdentification) != null) {
                dominantSpeakerIdentification.removePropertyChangeListener(this.propertyChangeListener);
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getDominantEndpoint() {
        Endpoint dominantEndpoint;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.dominantEndpoint == null) {
                dominantEndpoint = null;
            } else {
                dominantEndpoint = (Endpoint)this.dominantEndpoint.get();
                if (dominantEndpoint == null) {
                    this.dominantEndpoint = null;
                }
            }
        }
        return dominantEndpoint;
    }

    private DominantSpeakerIdentification getDominantSpeakerIdentification() {
        this.getActiveSpeakerDetector();
        return this.dominantSpeakerIdentification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> ret;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.endpoints == null) {
                Conference conference = this.getConference();
                if (conference == null) {
                    this.endpoints = new ArrayList<WeakReference<Endpoint>>();
                } else {
                    List<Endpoint> conferenceEndpoints = conference.getEndpoints();
                    this.endpoints = new ArrayList<WeakReference<Endpoint>>(conferenceEndpoints.size());
                    for (Endpoint endpoint : conferenceEndpoints) {
                        this.endpoints.add(new WeakReference<Endpoint>(endpoint));
                    }
                }
            }
            ret = new ArrayList<Endpoint>(this.endpoints.size());
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint endpoint = (Endpoint)i.next().get();
                if (endpoint == null) continue;
                ret.add(endpoint);
            }
        }
        return ret;
    }

    public void levelChanged(Channel channel, long ssrc, int level) {
        Endpoint endpoint;
        ActiveSpeakerDetector activeSpeakerDetector = this.getActiveSpeakerDetector();
        if (activeSpeakerDetector != null) {
            activeSpeakerDetector.levelChanged(ssrc, level);
        }
        if ((endpoint = channel.getEndpoint()) != null) {
            endpoint.audioLevelChanged(channel, ssrc, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void maybeStartEventDispatcher() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.eventDispatcher == null) {
                EventDispatcher eventDispatcher = new EventDispatcher(this);
                boolean scheduled = false;
                this.eventDispatcher = eventDispatcher;
                this.eventDispatcherTime = 0L;
                try {
                    executorService.execute(eventDispatcher);
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (scheduled) throw throwable;
                    if (this.eventDispatcher != eventDispatcher) throw throwable;
                    this.eventDispatcher = null;
                    this.eventDispatcherTime = 0L;
                    throw throwable;
                }
            }
            this.syncRoot.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        DominantSpeakerIdentification dominantSpeakerIdentification;
        Conference conference = this.getConference();
        if (conference == null || conference.isExpired()) {
            return;
        }
        String propertyName = ev.getPropertyName();
        if (Conference.ENDPOINTS_PROPERTY_NAME.equals(propertyName)) {
            if (conference.equals(ev.getSource())) {
                Object object = this.syncRoot;
                synchronized (object) {
                    this.endpointsChanged = true;
                    this.maybeStartEventDispatcher();
                }
            }
        } else if (!DominantSpeakerIdentification.DOMINANT_SPEAKER_PROPERTY_NAME.equals(propertyName) || (dominantSpeakerIdentification = this.dominantSpeakerIdentification) == null || dominantSpeakerIdentification.equals(ev.getSource())) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInEventDispatcher(EventDispatcher eventDispatcher) {
        boolean endpointsChanged = false;
        boolean dominantEndpointChanged = false;
        Object object = this.syncRoot;
        synchronized (object) {
            long wait;
            if (this.eventDispatcher != eventDispatcher) {
                return false;
            }
            Conference conference = this.getConference();
            if (conference == null || conference.isExpired()) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (!this.dominantEndpointChanged && !this.endpointsChanged && (wait = 100L - (now - this.eventDispatcherTime)) > 0L) {
                try {
                    this.syncRoot.wait(wait);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            this.eventDispatcherTime = now;
            List<Endpoint> conferenceEndpoints = conference.getEndpoints();
            if (this.endpoints == null) {
                this.endpoints = new ArrayList<WeakReference<Endpoint>>(conferenceEndpoints.size());
                for (Endpoint endpoint : conferenceEndpoints) {
                    this.endpoints.add(new WeakReference<Endpoint>(endpoint));
                }
                endpointsChanged = true;
            } else {
                Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
                while (i.hasNext()) {
                    Endpoint endpoint;
                    endpoint = (Endpoint)i.next().get();
                    if (endpoint == null) {
                        i.remove();
                        endpointsChanged = true;
                        continue;
                    }
                    if (conferenceEndpoints.contains(endpoint)) {
                        conferenceEndpoints.remove(endpoint);
                        continue;
                    }
                    i.remove();
                    endpointsChanged = true;
                }
                if (conferenceEndpoints.size() != 0) {
                    for (Endpoint endpoint : conferenceEndpoints) {
                        this.endpoints.add(new WeakReference<Endpoint>(endpoint));
                    }
                    endpointsChanged = true;
                }
            }
            this.endpointsChanged = false;
            Endpoint dominantEndpoint = this.getDominantEndpoint();
            if (dominantEndpoint != null) {
                int dominantEndpointIndex = -1;
                int count = this.endpoints.size();
                for (int i = 0; i < count; ++i) {
                    if (!dominantEndpoint.equals(this.endpoints.get(i).get())) continue;
                    dominantEndpointIndex = i;
                    break;
                }
                if (dominantEndpointIndex != -1 && dominantEndpointIndex != 0) {
                    WeakReference<Endpoint> weakReference = this.endpoints.remove(dominantEndpointIndex);
                    this.endpoints.add(0, weakReference);
                    endpointsChanged = true;
                }
            }
            if (this.dominantEndpointChanged) {
                dominantEndpointChanged = true;
                this.dominantEndpointChanged = false;
            }
        }
        if (endpointsChanged) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        if (dominantEndpointChanged) {
            this.firePropertyChange(DOMINANT_ENDPOINT_PROPERTY_NAME, null, null);
        }
        return true;
    }

    private static class EventDispatcher
    implements Runnable {
        private final WeakReference<ConferenceSpeechActivity> owner;

        public EventDispatcher(ConferenceSpeechActivity owner) {
            this.owner = new WeakReference<ConferenceSpeechActivity>(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ConferenceSpeechActivity owner;
                while ((owner = (ConferenceSpeechActivity)this.owner.get()) != null && owner.runInEventDispatcher(this)) {
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ConferenceSpeechActivity owner = (ConferenceSpeechActivity)this.owner.get();
                if (owner != null) {
                    owner.eventDispatcherExited(this);
                }
                throw throwable;
            }
            ConferenceSpeechActivity owner = (ConferenceSpeechActivity)this.owner.get();
            if (owner != null) {
                owner.eventDispatcherExited(this);
            }
        }
    }
}

